/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public class AbstractQuery {
    private QueryPath _path = null;

    private String _query = "";

    private List _parameterList = new ArrayList();

    private boolean _single = false;

    public boolean isSingle() {
        return _single;
    }

    public void setSingle(boolean sigle) {
        _single = sigle;
    }

    public AbstractQuery(QueryPath path) {
        _path = path;
    }

    public QueryPath getQueryPath() {
        return _path;
    }

    public String getFilePath() {
        return _path.getFilePath();
    }

    public String getName() {
        return _path.getName();
    }

    public void addParameter(Value value) {
        _parameterList.add(value);
    }

    public String getQuery() {
        return _query;
    }

    public void setQuery(String query) {
        _query = query;
    }

    public Iterator getParameterIterator() {
        return _parameterList.iterator();
    }

    public List getParameterList() {
        return _parameterList;
    }

}