/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.db.definition.QueryField;
import blanco.db.definition.TableField;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class SelectQuery extends AbstractQuery {
    private Type _instanceType = null;

    private Type _rowObjectType = null;

    private boolean _enableExpandAccesor = false;

    private boolean _enableGetAsObject = false;

    private boolean _enableGetAsList = false;

    private String _strScrollInterface = "forward_only";

    private boolean _enableUpdatableInterface = false;

    private List _fieldList = new ArrayList();

    public SelectQuery(QueryPath path) {
        super(path);
    }

    public SelectQuery(String name, String filePath) {
        this(new QueryPath(name, filePath));
    }

    public void addField(QueryField field) {
        _fieldList.add(field);
    }

    public TableField getField(int index) {
        return (TableField) _fieldList.get(index);
    }

    public int getFieldCount() {
        return _fieldList.size();
    }

    public Iterator getFieldIterator() {
        return _fieldList.iterator();
    }

    public boolean isEnableExpandAccesor() {
        return _enableExpandAccesor;
    }

    public void setEnableExpandAccesor(boolean enableExpandAccesor) {
        _enableExpandAccesor = enableExpandAccesor;
    }

    public boolean isEnableGetAsList() {
        return _enableGetAsList;
    }

    public void setEnableGetAsList(boolean enableGetAsList) {
        _enableGetAsList = enableGetAsList;
    }

    public boolean isEnableGetAsObject() {
        return _enableGetAsObject;
    }

    public void setEnableGetAsObject(boolean enableGetAsObject) {
        _enableGetAsObject = enableGetAsObject;
    }

    public Type getInstanceType() {
        return _instanceType;
    }

    public void setInstanceType(Type instanceType) {
        _instanceType = instanceType;
    }

    public Type getRowObjectType() {
        return _rowObjectType;
    }

    public void setRowObjectType(Type rowObjectType) {
        _rowObjectType = rowObjectType;
    }

    public String getScrollInterface() {
        return _strScrollInterface;
    }

    public void setScrollInterface(String strScrollInterface) {
        _strScrollInterface = strScrollInterface;
    }

    public boolean isEnableUpdatableInterface() {
        return _enableUpdatableInterface;
    }

    public void setEnableUpdatableInterface(boolean enableUpdatableInterface) {
        _enableUpdatableInterface = enableUpdatableInterface;
    }
}