/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class Table {
    private String _name = "";

    private String _alias = "";

    private List _keyFieldList = new ArrayList();

    public Table(String name) {
        _name = name;
    }

    public Table(String name, String alias) {
        _name = name;
        _alias = alias;
    }

    public String getName() {
        return _name;
    }

    public void setName(String name) {
        _name = name;
    }

    public String getAlias() {
        return _alias;
    }

    public void setAlias(String alias) {
        _alias = alias;
    }

    public boolean hasAlias() {
        return !_alias.equals("");
    }

    public void addKeyField(String name) {
        _keyFieldList.add(name);
    }

    public boolean hasKeyField() {
        return _keyFieldList.size() != 0;
    }

    public Iterator getKeyFieldItrator() {
        return _keyFieldList.iterator();
    }
}