/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbDefinition {
    private String _name = "";

    private List _tableGateways = new ArrayList();

    private List _queryIterators = new ArrayList();

    private List _queryInvokers = new ArrayList();


    public BlancoDbDefinition(String name) {
        _name = name;
    }

    public String getName() {
        return _name;
    }

    public void addTableGateway(TableGateway gateway) {
        _tableGateways.add(gateway);
    }

    public int getTableGatewayCount() {
        return _tableGateways.size();
    }

    public TableGateway getTableGateway(int index) {
        return (TableGateway) _tableGateways.get(index);
    }

    public Iterator getTableGatewayIterator() {
        return _tableGateways.iterator();
    }

    public Iterator getQueryIteratorIterator() {
        return _queryIterators.iterator();
    }

    public void addQueryInvoker(QueryInvoker invoker) {
        _queryInvokers.add(invoker);
    }

    public Iterator getQueryInvokerIterator() {
        return _queryInvokers.iterator();
    }

    public void setIteratorList(List invokerList) {
        _queryIterators = invokerList;

    }

    public void setInvokerList(List invokerList) {
        _queryInvokers = invokerList;
    }

    public void setGatewayList(List gatewayList) {
        _tableGateways = gatewayList;
    }

    public int getTargetObjectCount() {
        return _tableGateways.size() + _queryIterators.size()
                + _queryInvokers.size();

    }
}