/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.exception;

/**
 * f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ƂONX <br>
 * ̃NXblancoDb\[XR[hŗp܂ <br>
 * ̃NX́A\[XR[h̃t@CƂėp܂B
 * 
 * @since 2005.05.12
 * @author Tosiki Iga
 */
public class TooManyRowsModifiedException extends NotSingleRowException {
    /**
     * SQLState͉̒lƂĐݒ肵Ă܂B <br>
     * vO SQLStateɗ炸 ONXɂĔf悤ɂĂB
     */
    private static final String SQLSTATE_TOOMANYROWSMODIFIED = "00112";

    /**
     * f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ƂONX <br>
     * 
     * @deprecated Ri[邱Ƃłʂ̃RXgN^𗘗p邱ƂE߂܂B
     */
    public TooManyRowsModifiedException() {
        super("No row modified exception has occured.",
                SQLSTATE_TOOMANYROWSMODIFIED);
    }

    /**
     * f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ƂONX <br>
     * 
     * @param reason
     */
    public TooManyRowsModifiedException(String reason) {
        super(reason, SQLSTATE_TOOMANYROWSMODIFIED);
    }

    /**
     * f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ƂONX <br>
     * 
     * @param reason
     * @param SQLState
     */
    public TooManyRowsModifiedException(String reason, String SQLState) {
        super(reason, SQLState);
    }

    /**
     * f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ƂONX <br>
     * 
     * @param reason
     * @param SQLState
     * @param vendorCode
     */
    public TooManyRowsModifiedException(String reason, String SQLState,
            int vendorCode) {
        super(reason, SQLState, vendorCode);
    }
}