/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import java.sql.SQLException;

import blanco.db.properties.GenerationProperties;
import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class CloseMethod extends MethodExpander {
    private Value _statement = null;

    private GenerationProperties _properties = null;

    public CloseMethod() {
        super("close");

        String name = getNameAdjuster().toFieldName("Statement");
        _statement = new Value(java.sql.PreparedStatement.class, name);
        _properties = BlancoDbObjectStorage.getInstance()
                .getGenerationProperties();
    }

    public void setupSignature() {
        addException(SQLException.class);

        if (_properties.isGenerateJavaDoc()) {
            getJavaDoc().addLine("pĂJDBC\[X܂B<br>");
            getJavaDoc().addLine("NX̗pIۂɕK̃\bhĂяoĂB");
        }
    }

    public void implement() {
        _statement = getField("Statement");

        Implementor implementor = new Implementor(getData());
        Receiver r = null;

        Statement s = new Statement(_statement);
        s.join("!=", new Statement(Value.NULL));
        implementor.openIf(s);
        r = new Receiver(_statement);
        r.call("close");
        implementor.addStatement(r);
        implementor.assign(_statement, new Statement(Value.NULL));
        implementor.closeIf();
    }

}