/*
 * BlancoDbDefaultGenerator.
 * ƂT^IBlancoDbGenerator
 * 
 * Copyright (C) 2005 tosiki.iga@nifty.ne.jp
 */

package blanco.db.helper;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import blanco.db.BlancoDb;
import blanco.db.BlancoDbConstants;
import blanco.db.collector.BlancoDbDatabaseConnection;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.conf.BlancoDbMetadata;
import blanco.db.conf.BlancoDbSetting;
import blanco.db.conf.ExecuteQuery;
import blanco.db.conf.SelectQuery;
import blanco.db.exception.BlancoDbException;
import blanco.ig.generator.GenerationMode;

/**
 * blancoDb𗘗pۂ̂Ƃ{IGenerator܂B
 */
public abstract class BlancoDbDefaultGenerator implements IBlancoDbProgress {
    private boolean _isSupportOldVersionTableGateway = false;

    public void setSupportOldVersionTableGateway(boolean arg) {
        _isSupportOldVersionTableGateway = arg;
    }

    /**
     * łʓI blancoDbGenerators܂B
     * 
     * @param jdbcDriver
     *            JDBChCoNX
     * @param jdbcUrl
     *            JDBCڑURI
     * @param jdbcUsername
     *            JDBC[U
     * @param jdbcPassword
     *            JDBCpX[h
     * @param blancoSqlDirectory
     *            blancoSqli[ꂽfBNg.nullw̍ۂɂ͏XLbv܂.
     * @param rootPackage
     *            blancoɐݒ肷郋[gpbP[W
     * @return IȂtrue, ُIȂfalse
     * @throws BlancoDbException
     * @throws ParserConfigurationException
     * @throws IOException
     * @throws SAXException
     * @throws SQLException
     */
    public void process(BlancoDbDatabaseConnectionSettingDef connDef,
            File blancoSqlDirectory, String rootPackage,
            String blancoTargetSourceDirectory) throws SQLException,
            SAXException, IOException, ParserConfigurationException,
            BlancoDbException {
        System.out.println(BlancoDbConstants.PRODUCT_NAME + " ("
                + BlancoDbConstants.VERSION + ") \[XR[h: Jn.");

        BlancoDbSetting setting = new BlancoDbSetting();
        setting
                .setSupportOldVersionTableGateway(_isSupportOldVersionTableGateway);

        setting.setJdbc(connDef);
        setting.setMode(GenerationMode.OPERATION);
        if (blancoSqlDirectory != null) {
            // w肪ꍇɂ̂ SQL`t@Ci[fBNgZbg܂B
            setting.setQueryDirectory(blancoSqlDirectory.getAbsolutePath());
        }
        if (blancoTargetSourceDirectory != null) {
            setting.setWorkDirectory(blancoTargetSourceDirectory);
        }

        BlancoDbDatabaseConnection dbInfoCollector = new BlancoDbDatabaseConnection();
        try {
            if (dbInfoCollector.connect(connDef) == false) {
                System.err.println("f[^x[XڑɎs܂Bf܂B");
                return;
            }
            dbInfoCollector.getDatabaseVersionInfo();

            BlancoDb blancoDb = new BlancoDb(setting);
            setting.setRootNameSpace(rootPackage);

            if (blancoSqlDirectory != null) {
                // w肪ꍇɂ̂ SQL`t@Ci[fBNg܂B
                File[] fileSettingXml = blancoSqlDirectory.listFiles();
                for (int index = 0; index < fileSettingXml.length; index++) {
                    if (fileSettingXml[index].getName().endsWith(".xml") == false) {
                        // t@C̊gq xml ł̂̂ݏ܂B
                        continue;
                    }
                    if (progress(index + 1, fileSettingXml.length,
                            fileSettingXml[index].getName()) == false) {
                        break;
                    }

                    // ^͖ j܂B
                    BlancoDbMetadata metadata = new BlancoDbMetadata();
                    parseAndProcessBlancoDbSettingFile(fileSettingXml[index],
                            metadata);

                    // ̓t@Cɍs܂B
                    blancoDb.generate(metadata, dbInfoCollector);
                    if (_isSupportOldVersionTableGateway) {
                        blancoDb
                                .generateTableGateway(metadata, dbInfoCollector);
                    }
                }
            }

        } finally {
            dbInfoCollector.close();
            System.out.println("\[XR[h: I.");
        }
    }

    /**
     * BlancoDb SQL`t@Cp[XāAKv΃^ɒǉ܂B ̃\bh OĂяoꍇ܂B
     * 
     * @param fileSettingXml
     *            ͂ƂȂblancoDbݒt@C
     * @param metadata
     *            o͂ƂȂ郁^f[^
     */
    public void parseAndProcessBlancoDbSettingFile(File fileSettingXml,
            BlancoDbMetadata metadata) {
        System.out.println("t@C[" + fileSettingXml.getAbsolutePath()
                + "]܂");

        DocumentBuilderFactory documentFactory = DocumentBuilderFactory
                .newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentFactory.newDocumentBuilder();
        } catch (ParserConfigurationException ex1) {
            System.err.println("hLg쐬ɗO܂.:" + ex1.toString());
            ex1.printStackTrace();
            return;
        }
        try {
            document = documentBuilder.parse(fileSettingXml);
        } catch (SAXException e) {
            System.err.println("hLgp[XɗO܂:" + e.toString());
            e.printStackTrace();
            return;
        } catch (IOException e) {
            System.err.println("hLgp[XɗO܂:" + e.toString());
            e.printStackTrace();
            return;
        }
        Element blancoDbElement = document.getDocumentElement();
        if (blancoDbElement == null) {
            System.out.println("blanco-db[gm[h܂");
            return;
        }
        NodeList rootNodeList = blancoDbElement.getChildNodes();
        if (rootNodeList == null) {
            return;
        }
        int length = rootNodeList.getLength();
        for (int indexNodeList = 0; indexNodeList < length; indexNodeList++) {
            Node node = rootNodeList.item(indexNodeList);
            if (node.getNodeType() != Node.ELEMENT_NODE) {
                continue;
            }
            Element eleCommandQuery = (Element) node;
            String nodeName = eleCommandQuery.getNodeName();
            if (nodeName.equals(BlancoDbConstants.QUERY_ITERATOR)) {
                System.out.println("^ NG["
                        + eleCommandQuery.getAttribute("name") + "]");
                metadata.addSelectQuery(new SelectQuery(eleCommandQuery
                        .getAttribute("name"), fileSettingXml.getName()));
            } else if (nodeName.equals(BlancoDbConstants.QUERY_INVOKER)) {
                System.out.println("s^ NG["
                        + eleCommandQuery.getAttribute("name") + "]");
                metadata.addExecuteQuery(new ExecuteQuery(eleCommandQuery
                        .getAttribute("name"), fileSettingXml.getName()));
            }
        }
    }
}