/*
 * 쐬: 2005/05/21
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
package common;

import junit.framework.TestCase;
import blanco.ig.expander.NameAdjuster;

/**
 * @author iga
 * 
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv: EBhE - ݒ - Java - R[hEX^C -
 * R[hEev[g
 */
public class NameAdjusterTest extends TestCase {

    public void testGetMethodName() throws Exception {
        NameAdjuster adjuster = new NameAdjuster();
        assertEquals("getMyName", adjuster.getMethodName("get", "my_name"));
        assertEquals("getMyName", adjuster.getMethodName("get", "MY_NAME"));
        assertEquals("getMyNameIsFoo", adjuster.getMethodName("get",
                "my__name__is__foo"));

        assertEquals("getMyName", adjuster.getMethodName("get", "MyName"));
        assertEquals("getMyName", adjuster.getMethodName("get", "My_Name"));
        assertEquals("getMyName", adjuster.getMethodName("get", "MY NAME"));
        assertEquals("getMyName", adjuster.getMethodName("get", "my name"));

        assertEquals("getABc", adjuster.getMethodName("get", "a_bc"));

        assertEquals("getA", adjuster.getMethodName("get", "_a"));

        assertEquals("getA", adjuster.getMethodName("get", "a_"));
        assertEquals("getAB", adjuster.getMethodName("get", "a__b_"));

        assertEquals("getAB", adjuster.getMethodName("get", "a_b"));

        assertEquals("getAB", adjuster.getMethodName("get", "a__b"));
    }

    public void testToClassName() throws Exception {
        NameAdjuster adjuster = new NameAdjuster();
        assertEquals("AB", adjuster.toClassName("a_b"));
        assertEquals("A", adjuster.toClassName("a"));
        assertEquals("A", adjuster.toClassName("A"));
        assertEquals("A", adjuster.toClassName("_A"));

        assertEquals("Abc", adjuster.toClassName("abc"));
        assertEquals("ClassName", adjuster.toClassName("class_name"));
        assertEquals("ClassName", adjuster.toClassName("className"));
        assertEquals("ClassName", adjuster.toClassName("ClassName"));

        assertEquals("MyName", adjuster.toClassName("my_name"));
        assertEquals("MyName", adjuster.toClassName("MY_NAME"));
        assertEquals("MyName", adjuster.toClassName("MyName"));
        assertEquals("MyName", adjuster.toClassName("My_Name"));

        // ͓̕K؂ɏB
        assertEquals("AB", adjuster.toClassName("a__b"));
        assertEquals("AbCd", adjuster.toClassName("ab__cd"));
    }

    public void testToFieldName() throws Exception {
        NameAdjuster adjuster = new NameAdjuster();
        assertEquals("_aB", adjuster.toFieldName("a_b"));
        assertEquals("_aB", adjuster.toFieldName("a__b"));
        assertEquals("_myName", adjuster.toFieldName("my_name"));
        assertEquals("_myName", adjuster.toFieldName("MY_NAME"));
        assertEquals("_myName", adjuster.toFieldName("my name"));
        assertEquals("_myName", adjuster.toFieldName("MY NAME"));
        assertEquals("_myName", adjuster.toFieldName("MyName"));
    }

    public void testToShortClassName() throws Exception {
        NameAdjuster adjuster = new NameAdjuster();
        assertEquals("Integer", adjuster.toShortClassName(Integer.class));
    }

    public void testToTitleCase() throws Exception {
        NameAdjuster adjuster = new NameAdjuster();
        assertEquals("A_b", adjuster.toTitleCase("a_b"));
        assertEquals("A__b", adjuster.toTitleCase("a__b"));
        assertEquals("A__b", adjuster.toTitleCase("a__b"));
        assertEquals("MyName", adjuster.toTitleCase("MyName"));
        assertEquals("_myName", adjuster.toTitleCase("_myName"));
        assertEquals("MyName", adjuster.toTitleCase("myName"));
    }

    public void testToValueName() throws Exception {
        NameAdjuster adjuster = new NameAdjuster();
        assertEquals("aB", adjuster.toValueName("a_b"));
        assertEquals("myName", adjuster.toValueName("my_name"));
        assertEquals("myName", adjuster.toValueName("MY_NAME"));
        assertEquals("myName", adjuster.toValueName("my name"));
        assertEquals("myName", adjuster.toValueName("MY NAME"));
        assertEquals("myName", adjuster.toValueName("my__name"));
        assertEquals("myName", adjuster.toValueName("MY__NAME"));
        assertEquals("myName", adjuster.toValueName("MY_ NAME"));
        assertEquals("myNameIs", adjuster.toValueName("my__name__is"));
    }

}
