/*
 * blancoDbTutorial: blancoDb`[gAETv<br>
 * ʃf[^
 * 
 * Copyright (C) 2005 tosiki.iga@nifty.ne.jp
 */

package sql2k;

import igapyon.query.SimpleTestBlancoDbTable1ColumnColBinary100NotNullIterator;
import igapyon.query.SimpleTestBlancoDbTable1DeleteInvoker;
import igapyon.query.SimpleTestBlancoDbTable1InsertInvoker;
import igapyon.query.SimpleTestBlancoDbTable1SelectIterator;
import igapyon.query.TestBlancoDbTable1SelectAllIterator;
import igapyon.row.SimpleTestBlancoDbTable1ColumnColBinary100NotNullRow;
import igapyon.row.SimpleTestBlancoDbTable1SelectRow;
import igapyon.row.TestBlancoDbTable1SelectAllRow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import junit.framework.TestCase;

/**
 * : ̃NXRpC邽߂ɂ́A܂ł̎菇ŎblancoDb\[XR[hKvɂȂ܂B
 */
public class BlancoDbTest11Sql2k extends TestCase {
    /**
     * ʃf[^Ƃđ}s
     */
    //public static final int MAX_ROW_COUNT = 100000;
    public static final int MAX_ROW_COUNT = 10000;

    public static final boolean IS_PROCESS_DELETEINSERT = true;

    /**
     * JDBChCow肵܂B
     */
    public static final String JDBC_DRIVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";

    /**
     * JDBCڑ̕w肵܂B <br>
     * |Cg: SelectMethod=cursor ̎w͕K{łB
     */
    public static final String JDBC_URL = "jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=Northwind;SelectMethod=cursor";

    /**
     * JDBCڑ̃[Uw肵܂B
     */
    public static final String JDBC_USERNAME = "sa";

    /**
     * JDBCڑ̃pX[hw肵܂B
     */
    public static final String JDBC_PASSWORD = "password";

    public void testProcess01() throws Exception {
        Class.forName(JDBC_DRIVER);
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(JDBC_URL, JDBC_USERNAME,
                    JDBC_PASSWORD);
            conn.setAutoCommit(false);

            if (IS_PROCESS_DELETEINSERT) {
                // ܂̏Ԃɂ܂B
                processDeleteAll(conn);
                processInsert(conn);
            }

            processScrollCursor(conn);

            conn.commit();
            System.out.println("SĂ̏I܂.");
        } finally {
            conn.rollback();
            conn.close();
            conn = null;
        }
    }

    public void processDeleteAll(Connection conn) throws SQLException {
        System.out.println("svȍsꊇ폜܂B");
        TestBlancoDbTable1SelectAllIterator iterator = new TestBlancoDbTable1SelectAllIterator(
                conn);
        SimpleTestBlancoDbTable1DeleteInvoker invoker = new SimpleTestBlancoDbTable1DeleteInvoker(
                conn);
        try {
            for (int deleteCount = 0; iterator.next(); deleteCount++) {
                TestBlancoDbTable1SelectAllRow row = iterator.getRow();
                invoker.prepareStatement();
                invoker.setInputParameter(row.getColIntNotNull());
                //System.out.println("s[" + row.getColIntNotNull() + "]폜");
                invoker.executeSingleUpdate();

                if (deleteCount % 1000 == 999) {
                    conn.commit();
                    System.out.println("" + (deleteCount + 1)
                            + " 폜܂BR~bg܂B");
                }
            }
        } finally {
            invoker.close();
            iterator.close();
        }
    }

    public void processInsert(Connection conn) throws SQLException, IOException {
        System.out.println("s̑}݂܂");
        SimpleTestBlancoDbTable1InsertInvoker invoker = new SimpleTestBlancoDbTable1InsertInvoker(
                conn);
        SimpleTestBlancoDbTable1SelectIterator iterator = new SimpleTestBlancoDbTable1SelectIterator(
                conn);
        SimpleTestBlancoDbTable1ColumnColBinary100NotNullIterator iteratorCol = new SimpleTestBlancoDbTable1ColumnColBinary100NotNullIterator(
                conn);
        try {
            for (int index = 0; index < MAX_ROW_COUNT; index++) {
                invoker.setInputParameter((index + 1), new Integer(index + 1),
                        (short) 3, new Short((short) 4), (long) 5, new Long(6),
                        (float) 7.1, new Float(8.2), 9.3, new Double(10.4),
                        new BigDecimal("11"), new BigDecimal("12"),
                        new BigDecimal("13"), new BigDecimal("14"),
                        new BigDecimal("15.2"), new BigDecimal("16.4"), false,
                        new Boolean(true), new ByteArrayInputStream("ABC123"
                                .getBytes()), 6, new ByteArrayInputStream(
                                "DEF456".getBytes()), 6,
                        new ByteArrayInputStream("GHI789".getBytes()), 6,
                        new ByteArrayInputStream("JKL012".getBytes()), 6, "1",
                        "2", "34", "56", "7890", "1234", "5678", "9012",
                        "3456", "7890", "1234", "5678", "12345678", "12345678",
                        "colNVarchar255Null", new StringReader("ABC"), 3,
                        new Date(), new Date());
                invoker.executeSingleUpdate();

                if (index % 1000 == 999) {
                    conn.commit();
                    System.out.println("" + (index + 1)
                            + " }܂BR~bg܂B");
                }
            }

            // }̐`FbN܂B
            iterator.setInputParameter(5);
            iterator.next();
            SimpleTestBlancoDbTable1SelectRow row = iterator.getRow();
            assertTrue(row.getColDecimal153Null().compareTo(
                    new BigDecimal("16.4")) == 0);

            iteratorCol.setInputParameter(5);
            assertTrue(iteratorCol.next());
            SimpleTestBlancoDbTable1ColumnColBinary100NotNullRow rowBinary = iteratorCol
                    .getRow();
            InputStream inStream = rowBinary.getColBinary100NotNull();
            for (;;) {
                int iRead = inStream.read();
                if (iRead < 0)
                    break;
            }
        } finally {
            iteratorCol.close();
            iterator.close();
            invoker.close();
        }
    }

    public void processScrollCursor(Connection conn) throws SQLException,
            IOException {
        System.out.println("s̃XN[݂܂");
        TestBlancoDbTable1SelectAllIterator iterator = new TestBlancoDbTable1SelectAllIterator(
                conn);
        try {
            iterator.prepareStatement(iterator.getQuery(),
                    ResultSet.TYPE_SCROLL_INSENSITIVE,
                    ResultSet.CONCUR_READ_ONLY);

            System.out.println("ŏ̍sֈʒuÂ. (ʃZbg̍쐬𔺂̂ŁAӊOɂŎԂ܂.)");
            assertTrue(iterator.next());
            System.out.println("9000sփWv");
            assertTrue(iterator.absolute(9000));
            System.out.println("5000s10s擾");
            List list = iterator.getList(5000, 10);
            for (int count = 0; count < list.size(); count++) {
                TestBlancoDbTable1SelectAllRow row = (TestBlancoDbTable1SelectAllRow) list
                        .get(count);
                assertEquals(row.getColIntNotNull(), 5000 + count);
            }

            System.out.println("8000sփWv");
            assertTrue(iterator.absolute(8000));
            list = iterator.getList(8000, 10);
            for (int count = 0; count < list.size(); count++) {
                TestBlancoDbTable1SelectAllRow row = (TestBlancoDbTable1SelectAllRow) list
                        .get(count);
                assertEquals(row.getColIntNotNull(), 8000 + count);
            }

            System.out.println("I[ł" + MAX_ROW_COUNT + "sփWv");
            assertTrue(iterator.absolute(MAX_ROW_COUNT));
            TestBlancoDbTable1SelectAllRow row = iterator.getRow();
            assertEquals(row.getColIntNotNull(), MAX_ROW_COUNT);
            assertFalse(iterator.absolute(MAX_ROW_COUNT + 1));

            System.out.println("3000sփWv");
            assertTrue(iterator.absolute(3000));
            row = iterator.getRow();
            assertEquals(row.getColIntNotNull(), 3000);

            System.out.println("2997sփWv");
            assertTrue(iterator.relative(-3));
            row = iterator.getRow();
            assertEquals(row.getColIntNotNull(), 2997);

        } finally {
            iterator.close();
        }

    }
}