/*
 * blancoCommons Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.calc.parser.block;

/**
 * @author iga
 */
public abstract class AbstractBlancoCalcParserBlock {

    /**
     * Ỷ䖝 (^Cgs̃JEg)
     */
    private int waitForValueY = 1;

    /**
     * ubN̊JnQ
     */
    private String[] startString = null;

    /**
     * ubN̏IQ
     */
    private String[] endString = null;

    /**
     * ubNɗ^ꂽO(ID)
     */
    private String blockName = "name";

    /**
     * l}bsO
     */
    private BlancoCalcParserValueMapping[] valueMapping = null;

    /**
     * ubN̖O擾܂B
     * 
     * @return
     */
    public String getName() {
        return blockName;
    }

    /**
     * ubN̖Oݒ肵܂B
     * 
     * @param arg
     */
    public void setName(String arg) {
        blockName = arg;
    }

    /**
     * JnQZbg܂
     * 
     * @param arg
     */
    public void setStartString(String[] arg) {
        startString = arg;
    }

    /**
     * JnɃqbg邩ǂ܂B
     * 
     * @param arg
     * @return
     */
    public boolean isStartString(String arg) {
        if (startString == null) {
            return false;
        }
        for (int index = 0; index < startString.length; index++) {
            if (startString[index].equals(arg)) {
                return true;
            }
        }
        return false;
    }

    /**
     * IQZbg܂
     * 
     * @param arg
     */
    public void setEndString(String[] arg) {
        endString = arg;
    }

    /**
     * IɃqbg邩ǂ܂B
     * 
     * @param arg
     * @return
     */
    public boolean isEndString(String arg) {
        if (endString == null) {
            return false;
        }
        for (int index = 0; index < endString.length; index++) {
            if (endString[index].equals(arg)) {
                return true;
            }
        }
        return false;
    }

    public void setSearchRangeY(int arg) {
        waitForValueY = arg;
    }

    public int getSearchRangeY() {
        return waitForValueY;
    }

    public void setValueMapping(BlancoCalcParserValueMapping[] mapping) {
        valueMapping = mapping;
    }

    public BlancoCalcParserValueMapping[] getValueMapping() {
        return valueMapping;
    }
}
