/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.definition.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class FormEvent {

    private String _name = "";

    private String _description = "";

    /**
     * ړ{ꖼ
     */
    private String _koumokuNihongoMei = "";

    private boolean _ischeckToken = false;

    private List _validationField = new ArrayList();

    public FormEvent(String name) {
        _name = name;
    }

    public FormEvent(String name, String description) {
        _name = name;
        _description = description;
    }

    public String getDescription() {
        return _description;
    }

    public void setDescription(String description) {
        _description = description;
    }

    public String getName() {
        return _name;
    }

    public void addValidationField(FormField field) {
        _validationField.add(field);
    }

    public Iterator getValidationFieldIterator() {
        return _validationField.iterator();
    }

    /**
     * @return _ischeckToken ߂܂B
     */
    public boolean isCheckToken() {
        return _ischeckToken;
    }

    /**
     * @param argCheckToken
     *            _ischeckToken ݒB
     */
    public void setCheckToken(boolean argCheckToken) {
        _ischeckToken = argCheckToken;
    }

    /**
     * @return _koumokuNihongoMei ߂܂B
     */
    public String getKoumokuNihongoMei() {
        return _koumokuNihongoMei;
    }

    /**
     * @param nihongoMei
     *            _koumokuNihongoMei ݒB
     */
    public void setKoumokuNihongoMei(String nihongoMei) {
        _koumokuNihongoMei = nihongoMei;
    }
}
