/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.expander.action;

import java.util.Iterator;

import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.ImplementData;
import blanco.ig.expander.method.MethodExpander;
import blanco.struts.definition.form.Form;
import blanco.struts.definition.form.FormEvent;

/**
 * @author Yasuo Nakanishi
 */
public class DispatchMethod extends MethodExpander {
    private String _eventParameterName = null;

    private String _methodName = null;

    private Form _form = null;

    private Type _formType = null;

    public DispatchMethod(String methodName, String eventParameterName,
            Type formType, Form form) {
        super(methodName);
        _methodName = methodName;
        _eventParameterName = eventParameterName;
        _form = form;
        _formType = formType;
    }

    public void setupSignature() {
        setScope(Scope.PUBLIC);

        addException(new Type("java.lang.Exception"));

        getJavaDoc().addParameter("mapping", "ActionMappingIuWFNgB");
        addArgument(new Value(
                new Type("org.apache.struts.action.ActionMapping"), "mapping"));
        // tH[͎֘AۃNXZbg܂B
        getJavaDoc().addParameter("form", "Strutsn ActionForm IuWFNgB");
        addArgument(new Value(new Type("org.apache.struts.action.ActionForm"),
                "form"));
        getJavaDoc().addParameter("request", "Servlet瓾requestIuWFNgB");
        addArgument(new Value(
                new Type("javax.servlet.http.HttpServletRequest"), "request"));
        getJavaDoc().addParameter("response", "Servlet瓾responseIuWFNgB");
        addArgument(new Value(
                new Type("javax.servlet.http.HttpServletResponse"), "response"));
        if (_form.isUsingDb()) {
            getJavaDoc().addParameter("connection", "f[^x[XڑIuWFNgB");
            addArgument(new Value(new Type("java.sql.Connection"), "connection"));
        }

        setScope(Scope.PUBLIC);
        setFinal(true);
        setReturnType(new Type("org.apache.struts.action.ActionForward"));

        getJavaDoc().addLine("NGXgɂăCxg̐U蕪s܂B");
        getJavaDoc().addLine(_methodName + " \bhB");
    }

    public void implement() {
        getData().addLine("ActionForward result = null;");
        getData().addLine(
                _form.getName() + " actionForm = (" + _form.getName()
                        + ") form;");
        getData().addLine("");
        getData().addLine(
                "String event = request.getParameter(\"" + _eventParameterName
                        + "\");");
        getData().addLine("if (event == null || event.equals(\"\")) {");
        getData().addLine(
                "event = (String) request.getAttribute(\""
                        + _eventParameterName + "\");");
        getData().addLine("}");
        getData().addLine("if (event == null || event.equals(\"\")){");
        getData().addLine("String message = \"CxgIDUIn܂łB\";");
        getData().addLine("throw new Exception(message);");
        getData().addLine("}");
        getData().addLine("");

        if (_form.isUsingDb()) {
            getData()
                    .addLine(
                            "init(mapping, actionForm, request, response, connection);");
        } else {
            getData().addLine("init(mapping, actionForm, request, response);");
        }
        getData().addLine("");
        getData().addLine("if (event.equals(\"load\")){");
        if (_form.isUsingDb()) {
            getData()
                    .addLine(
                            "result = onLoad(mapping, actionForm, request, response, connection);");
        } else {
            getData().addLine(
                    "result = onLoad(mapping, actionForm, request, response);");
        }

        Iterator eventIterator = _form.getEventIterator();
        // 2005.05.26 t.iga CxgIDɂU蕪{
        while (eventIterator.hasNext()) {
            FormEvent formEvent = (FormEvent) eventIterator.next();

            getData().addLine(
                    "} else if (event.equals(\"" + formEvent.getName()
                            + "\")) {");

            callOnEvent(getData(), formEvent);

            if (formEvent.getKoumokuNihongoMei() != null
                    && formEvent.getKoumokuNihongoMei().length() > 0) {
                // 2005.05.26 t.iga ړ{ꖼĂꍇɂ́Ałr܂B
                getData().addLine(
                        "} else if (event.equals(\""
                                + formEvent.getKoumokuNihongoMei() + "\")) {");
                getData().addLine("// uړ{ꖼv̎w肪̂ŃCxgU蕪ɗp܂.");

                callOnEvent(getData(), formEvent);
            }
        }
        getData().addLine("} else {");
        getData().addLine("String message = \"sȃCxgIDUIn܂BCxgID:\";");
        getData().addLine("message += event;");
        getData().addLine("throw new Exception(message);");
        getData().addLine("}");

        // saveTokenLȏꍇɐ܂B
        if (_form.isSaveToken()) {
            getData().addLine("");
            getData().addLine(
                    "// Actionݒ  Tokenۑ Lɐݒ肳Ă̂ Tokenۑ܂B");
            getData().addLine("saveToken(request);");
            getData().addLine("");
        }
        getData().addLine("return result;");
    }

    /**
     * OnEvent܂B
     * 
     * @param si
     * @param result
     * @param parameters
     * @param formEvent
     */
    private void callOnEvent(ImplementData si, FormEvent formEvent) {
        if (formEvent.isCheckToken()) {
            si.addLine("// TokenmF̎dg݂ɑ}");
            si.addLine("// TokenmF ̐ݒ肪LɂȂĂ܂");
            si.addLine("if (!isTokenValid(request, true)) {");
            si.addLine("// Token ȏꍇ̃G[s܂iƖAPŎj");

            String strLine = "result = foundInvalidTokenOnClick"
                    + getNameAdjuster().toTitleCase(formEvent.getName())
                    + "(mapping, actionForm, request, response";
            if (_form.isUsingDb()) {
                strLine += ", connection";
            }
            strLine += ");";
            si.addLine(strLine);

            si.addLine("if (result != null) {");
            si.addLine("return result;");
            si.addLine("}");
            si.addLine("}");
        }

        String eventMethod = EventMethod.createEventName(formEvent.getName());
        if (_form.isUsingDb()) {
            si.addLine("result = " + eventMethod
                    + "(mapping, actionForm, request, response, connection);");
        } else {
            si.addLine("result = " + eventMethod
                    + "(mapping, actionForm, request, response);");
        }
    }
}
