/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.struts.expander.form;

import java.util.Hashtable;
import java.util.Map;

import blanco.core.datastruct.DataStructClass;
import blanco.core.datastruct.DataStructDefinition;
import blanco.ig.expander.Type;
import blanco.ig.expander.field.FieldExpander;

/**
 * ̃NXblanco.struts.expander.formɔzuĂB
 * StrutsGenerator#createTableItem()ō쐬ĂCX^X ̃NXɒuĂB
 * 
 * @author Yasuo Nakanishi
 */
public class TableItemClass extends DataStructClass {

    public TableItemClass(Type type, DataStructDefinition definition) {
        super(type, definition);
    }

    protected void expandClassStruct() {
        super.expandClassStruct();

        FieldExpander field = null;
        for (int i = 0; i < getFieldCount(); i++) {
            field = getField(i);
            if (field.getFieldValue().getType().equals(Map.class)) {
                field.setDefaultValue(Hashtable.class);
            }
        }
    }
}
