/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.wsdl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.commons.util.BlancoXmlUtil;
import blanco.xsd.concretesax.BlancoXsdHandler;

/**
 * blancoWsdl: XMLWSDL쐬܂B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlXml2Wsdl {

    public static void main(String[] args) {
        try {
            new BlancoWsdlXml2Wsdl().process(
                    new File("./tmp/telegram/aaa.xml"), new File(
                            "tmp/telegram/wsdl"));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void process(File fileSource, File directoryTarget)
            throws IOException, TransformerException, SAXException {
        DOMResult result = new DOMResult();
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(fileSource);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
        }

        Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            Document rootDocument = (Document) rootNode;
            NodeList listSheet = rootDocument.getElementsByTagName("sheet");
            int sizeListSheet = listSheet.getLength();

            // ܂uŏ́vd`A
            // EFuT[rXIDȂǂ擾B
            String webServiceId = null;
            // lƂāAl˂ł܂B
            String telegramProcessNamespace = "http://noname.org/noname";
            // lƂāAl˂ł܂B
            String location = "http://localhost:8080/noname";
            String telegramRequestId = null;
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);
                // System.out.println("V[g[" + elementSheet.getAttribute("name")
                // + "]");

                NodeList listTelegramProcess = elementSheet
                        .getElementsByTagName("telegramProcess");
                if (listTelegramProcess.getLength() == 0) {
                    continue;
                }

                Element elementCommon = (Element) listTelegramProcess.item(0);

                final String telemgramProcessId = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramProcessId");
                if (telemgramProcessId == null) {
                    System.out.println("telegramProcessId܂B");
                    continue;
                }

                telegramRequestId = BlancoXmlUtil.getTextContent(elementCommon,
                        "telegramRequestId");
                if (telegramRequestId == null) {
                    System.out.println("telegramRequestId܂B");
                    continue;
                }

                final String telegramResponseId = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramResponseId");
                if (telegramResponseId == null) {
                    System.out.println("telegramResponseId܂B");
                    continue;
                }

                webServiceId = BlancoXmlUtil.getTextContent(elementCommon,
                        "webServiceId");
                telegramProcessNamespace = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramProcessNamespace");
                location = BlancoXmlUtil.getTextContent(elementCommon,
                        "location");
            }

            if (webServiceId == null) {
                // EFuT[rXIDm肵Ȃꍇɂ͗E܂B
                return;
            }

            // O̊m肪B
            OutputStream outStream = null;
            try {
                final String xsdNamespace = getNamespaceFromXsd(new File(
                        directoryTarget.getAbsolutePath() + "/"
                                + telegramRequestId + ".xsd"));

                directoryTarget.mkdirs();
                outStream = new FileOutputStream(directoryTarget
                        .getAbsolutePath()
                        + "/" + webServiceId + "WebService.wsdl");
                TransformerFactory tf = TransformerFactory.newInstance();
                SAXTransformerFactory saxTf = (SAXTransformerFactory) tf;
                TransformerHandler saxHandler;
                saxHandler = saxTf.newTransformerHandler();
                saxHandler.setResult(new StreamResult(outStream));
                saxHandler.startDocument();
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "targetNamespace",
                        "targetNamespace", "CDATA", telegramProcessNamespace);
                attributes.addAttribute("", "tns", "xmlns:tns", "CDATA",
                        telegramProcessNamespace);
                attributes.addAttribute("", "wsdl", "xmlns:wsdl", "CDATA",
                        "http://schemas.xmlsoap.org/wsdl/");
                attributes.addAttribute("", "xsd", "xmlns:xsd", "CDATA",
                        "http://www.w3.org/2001/XMLSchema");
                attributes.addAttribute("", "http", "xmlns:http", "CDATA",
                        "http://schemas.xmlsoap.org/wsdl/http/");
                attributes.addAttribute("", "soap", "xmlns:soap", "CDATA",
                        "http://schemas.xmlsoap.org/wsdl/soap/");
                attributes.addAttribute("", "mime", "xmlns:mime", "CDATA",
                        "http://schemas.xmlsoap.org/wsdl/mime/");
                attributes.addAttribute("", "impl", "xmlns:impl", "CDATA",
                        xsdNamespace);
                saxHandler.startElement("", "definitions", "wsdl:definitions",
                        attributes);

                for (int index = 0; index < sizeListSheet; index++) {
                    final Element elementSheet = (Element) listSheet
                            .item(index);
                    // System.out.println("V[g["
                    // + elementSheet.getAttribute("name") + "]");

                    NodeList listTelegramProcess = elementSheet
                            .getElementsByTagName("telegramProcess");
                    if (listTelegramProcess.getLength() == 0) {
                        continue;
                    }

                    Element elementCommon = (Element) listTelegramProcess
                            .item(0);

                    final String telemgramProcessId = BlancoXmlUtil
                            .getTextContent(elementCommon, "telegramProcessId");
                    if (telemgramProcessId == null) {
                        System.out.println("telegramProcessId܂B");
                        continue;
                    }

                    telegramRequestId = BlancoXmlUtil.getTextContent(
                            elementCommon, "telegramRequestId");
                    if (telegramRequestId == null) {
                        System.out.println("telegramRequestId܂B");
                        continue;
                    }

                    final String telegramResponseId = BlancoXmlUtil
                            .getTextContent(elementCommon, "telegramResponseId");
                    if (telegramResponseId == null) {
                        System.out.println("telegramResponseId܂B");
                        continue;
                    }

                    expandSheet(elementSheet, elementCommon, saxHandler,
                            directoryTarget);

                }

                // portTypẽGABłWebServicẽ\bhW񂵂܂B
                attributes = new AttributesImpl();
                attributes.addAttribute("", "name", "name", "CDATA",
                        webServiceId);
                saxHandler.startElement("", "portType", "wsdl:portType",
                        attributes);
                for (int index = 0; index < sizeListSheet; index++) {
                    final Element elementSheet = (Element) listSheet
                            .item(index);
                    NodeList listTelegramProcess = elementSheet
                            .getElementsByTagName("telegramProcess");
                    if (listTelegramProcess.getLength() == 0) {
                        continue;
                    }
                    Element elementCommon = (Element) listTelegramProcess
                            .item(0);
                    final String telemgramProcessId = BlancoXmlUtil
                            .getTextContent(elementCommon, "telegramProcessId");
                    if (telemgramProcessId == null) {
                        continue;
                    }
                    telegramRequestId = BlancoXmlUtil.getTextContent(
                            elementCommon, "telegramRequestId");
                    if (telegramRequestId == null) {
                        continue;
                    }
                    final String telegramResponseId = BlancoXmlUtil
                            .getTextContent(elementCommon, "telegramResponseId");
                    if (telegramResponseId == null) {
                        continue;
                    }

                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "name", "name", "CDATA",
                            telemgramProcessId);
                    saxHandler.startElement("", "operation", "wsdl:operation",
                            attributes);

                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "message", "message", "CDATA",
                            "tns:" + telegramRequestId);
                    saxHandler.startElement("", "input", "wsdl:input",
                            attributes);
                    saxHandler.endElement("", "input", "wsdl:input");

                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "message", "message", "CDATA",
                            "tns:" + telegramResponseId);
                    saxHandler.startElement("", "output", "wsdl:output",
                            attributes);
                    saxHandler.endElement("", "output", "wsdl:output");

                    saxHandler.endElement("", "operation", "wsdl:operation");
                }
                saxHandler.endElement("", "portType", "wsdl:portType");

                // binding̃GABłWebServicẽ\bhW񂵂܂B
                attributes = new AttributesImpl();
                attributes.addAttribute("", "name", "name", "CDATA",
                        webServiceId + "Binding");
                attributes.addAttribute("", "type", "type", "CDATA", "tns:"
                        + webServiceId);
                saxHandler.startElement("", "binding", "wsdl:binding",
                        attributes);

                attributes = new AttributesImpl();
                attributes.addAttribute("", "style", "style", "CDATA",
                        "document");
                attributes.addAttribute("", "transport", "transport", "CDATA",
                        "http://schemas.xmlsoap.org/soap/http");
                saxHandler.startElement("", "binding", "soap:binding",
                        attributes);
                saxHandler.endElement("", "binding", "soap:binding");

                for (int index = 0; index < sizeListSheet; index++) {
                    final Element elementSheet = (Element) listSheet
                            .item(index);
                    NodeList listTelegramProcess = elementSheet
                            .getElementsByTagName("telegramProcess");
                    if (listTelegramProcess.getLength() == 0) {
                        continue;
                    }
                    Element elementCommon = (Element) listTelegramProcess
                            .item(0);
                    final String telemgramProcessId = BlancoXmlUtil
                            .getTextContent(elementCommon, "telegramProcessId");
                    if (telemgramProcessId == null) {
                        continue;
                    }
                    telegramRequestId = BlancoXmlUtil.getTextContent(
                            elementCommon, "telegramRequestId");
                    if (telegramRequestId == null) {
                        continue;
                    }
                    final String telegramResponseId = BlancoXmlUtil
                            .getTextContent(elementCommon, "telegramResponseId");
                    if (telegramResponseId == null) {
                        continue;
                    }

                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "name", "name", "CDATA",
                            telemgramProcessId);
                    saxHandler.startElement("", "operation", "wsdl:operation",
                            attributes);

                    attributes = new AttributesImpl();
                    saxHandler.startElement("", "operation", "soap:operation",
                            attributes);
                    saxHandler.endElement("", "operation", "soap:operation");

                    attributes = new AttributesImpl();
                    saxHandler.startElement("", "input", "wsdl:input",
                            attributes);
                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "use", "use", "CDATA",
                            "literal");
                    saxHandler
                            .startElement("", "body", "soap:body", attributes);
                    saxHandler.endElement("", "body", "soap:body");
                    saxHandler.endElement("", "input", "wsdl:input");

                    attributes = new AttributesImpl();
                    saxHandler.startElement("", "output", "wsdl:output",
                            attributes);
                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "use", "use", "CDATA",
                            "literal");
                    saxHandler
                            .startElement("", "body", "soap:body", attributes);
                    saxHandler.endElement("", "body", "soap:body");
                    saxHandler.endElement("", "output", "wsdl:output");

                    saxHandler.endElement("", "operation", "wsdl:operation");
                }
                saxHandler.endElement("", "binding", "wsdl:binding");

                // servicẽGAB
                attributes = new AttributesImpl();
                attributes.addAttribute("", "name", "name", "CDATA",
                        webServiceId + "Service");
                saxHandler.startElement("", "service", "wsdl:service",
                        attributes);

                attributes = new AttributesImpl();
                attributes.addAttribute("", "name", "name", "CDATA",
                        webServiceId);
                attributes.addAttribute("", "binding", "binding", "CDATA",
                        "tns:" + webServiceId + "Binding");
                saxHandler.startElement("", "port", "wsdl:port", attributes);

                attributes = new AttributesImpl();
                attributes.addAttribute("", "location", "location", "CDATA",
                        location);
                saxHandler.startElement("", "address", "soap:address",
                        attributes);
                saxHandler.endElement("", "address", "soap:address");

                saxHandler.endElement("", "port", "wsdl:port");

                saxHandler.endElement("", "service", "wsdl:service");
                // servicẽGA

                saxHandler.endElement("", "definitions", "wsdl:definitions");
                saxHandler.endDocument();
            } finally {
                if (outStream != null) {
                    outStream.close();
                }
            }
        }
    }

    static void expandSheet(final Element elementSheet,
            final Element elementCommon, final TransformerHandler saxHandler,
            final File directoryTarget) throws SAXException {
        final String telegramRequestId = BlancoXmlUtil.getTextContent(
                elementCommon, "telegramRequestId");
        final String telegramResponseId = BlancoXmlUtil.getTextContent(
                elementCommon, "telegramResponseId");
        final String telegramProcessNamespace = BlancoXmlUtil.getTextContent(
                elementCommon, "telegramProcessNamespace");

        // wsdl:types
        AttributesImpl attributes = new AttributesImpl();
        saxHandler.startElement("", "types", "wsdl:types", attributes);

        attributes = new AttributesImpl();
        attributes.addAttribute("", "targetNamespace", "targetNamespace",
                "CDATA", telegramProcessNamespace);
        attributes.addAttribute("", "tns", "xmlns:tns", "CDATA",
                telegramProcessNamespace);
        attributes.addAttribute("", "xsd", "xmlns:xsd", "CDATA",
                "http://www.w3.org/2001/XMLSchema");
        saxHandler.startElement("", "schema", "xsd:schema", attributes);

        attributes = new AttributesImpl();
        attributes.addAttribute("", "schemaLocation", "schemaLocation",
                "CDATA", telegramRequestId + ".xsd");
        saxHandler.startElement("", "include", "xsd:include", attributes);
        saxHandler.endElement("", "include", "xsd:include");

        attributes = new AttributesImpl();
        attributes.addAttribute("", "schemaLocation", "schemaLocation",
                "CDATA", telegramResponseId + ".xsd");
        saxHandler.startElement("", "include", "xsd:include", attributes);
        saxHandler.endElement("", "include", "xsd:include");

        attributes = new AttributesImpl();
        attributes.addAttribute("", "name", "name", "CDATA", telegramRequestId);
        attributes.addAttribute("", "type", "type", "CDATA", "impl:"
                + telegramRequestId);
        saxHandler.startElement("", "element", "xsd:element", attributes);
        saxHandler.endElement("", "element", "xsd:element");

        attributes = new AttributesImpl();
        attributes
                .addAttribute("", "name", "name", "CDATA", telegramResponseId);
        attributes.addAttribute("", "type", "type", "CDATA", "impl:"
                + telegramResponseId);
        saxHandler.startElement("", "element", "xsd:element", attributes);
        saxHandler.endElement("", "element", "xsd:element");

        saxHandler.endElement("", "schema", "xsd:schema");

        saxHandler.endElement("", "types", "wsdl:types");
        // wsdl:types

        // wsdl:message
        attributes = new AttributesImpl();
        attributes.addAttribute("", "name", "name", "CDATA", telegramRequestId);
        saxHandler.startElement("", "message", "wsdl:message", attributes);

        attributes = new AttributesImpl();
        attributes.addAttribute("", "name", "name", "CDATA", "input");
        attributes.addAttribute("", "element", "element", "CDATA", "tns:"
                + telegramRequestId);
        saxHandler.startElement("", "part", "wsdl:part", attributes);
        saxHandler.endElement("", "part", "wsdl:part");

        saxHandler.endElement("", "message", "wsdl:message");
        // wsdl:message

        // wsdl:message
        attributes = new AttributesImpl();
        attributes
                .addAttribute("", "name", "name", "CDATA", telegramResponseId);
        saxHandler.startElement("", "message", "wsdl:message", attributes);

        attributes = new AttributesImpl();
        attributes.addAttribute("", "name", "name", "CDATA", "output");
        attributes.addAttribute("", "element", "element", "CDATA", "tns:"
                + telegramResponseId);
        saxHandler.startElement("", "part", "wsdl:part", attributes);
        saxHandler.endElement("", "part", "wsdl:part");

        saxHandler.endElement("", "message", "wsdl:message");
        // wsdl:message

    }

    /**
     * XSD̖OԂ擾܂B
     * 
     * @param fileXsd
     * @return
     * @throws IOException
     * @throws TransformerException
     */
    private static final String getNamespaceFromXsd(File fileXsd)
            throws IOException, TransformerException {
        final StringBuffer strbufTargetNamespace = new StringBuffer();
        SAXResult result = new SAXResult(new BlancoXsdHandler() {
            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void startElementXsdSchema(String uri, String localName,
                    String qName, String attrTargetNamespace,
                    String attrXmlnsTns, String attrXmlnsXsd)
                    throws SAXException {
                strbufTargetNamespace.append(attrTargetNamespace);
            }

            public void endElementXsdSchema(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdSchema(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSchema(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdSimpleType(String uri, String localName,
                    String qName, String attrName) throws SAXException {
            }

            public void endElementXsdSimpleType(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdSimpleType(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSimpleType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdRestriction(String uri,
                    String localName, String qName, String attrBase)
                    throws SAXException {
            }

            public void endElementXsdRestriction(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdRestriction(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdRestriction(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMinLength(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
            }

            public void endElementXsdMinLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMinLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdMinLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMaxLength(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
            }

            public void endElementXsdMaxLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMaxLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdMaxLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdPattern(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
            }

            public void endElementXsdPattern(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdPattern(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdPattern(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMinInclusive(String uri,
                    String localName, String qName, String attrValue)
                    throws SAXException {
            }

            public void endElementXsdMinInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMinInclusive(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdMinInclusive(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementXsdMaxInclusive(String uri,
                    String localName, String qName, String attrValue)
                    throws SAXException {
            }

            public void endElementXsdMaxInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMaxInclusive(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdMaxInclusive(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementXsdLength(String uri, String localName,
                    String qName, String attrValue, String attrFixed)
                    throws SAXException {
            }

            public void endElementXsdLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdComplexType(String uri,
                    String localName, String qName, String attrName)
                    throws SAXException {
            }

            public void endElementXsdComplexType(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdComplexType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdComplexType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdSequence(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementXsdSequence(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdSequence(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSequence(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void endElementXsdElement(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdElement(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdElement(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdElement(String uri, String localName,
                    String qName, String attrName, String attrType,
                    String attrMinOccurs, String attrMaxOccurs)
                    throws SAXException {
            }
        });

        InputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(fileXsd));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        return strbufTargetNamespace.toString();
    }

    static final String[] splitPath(String arg) {
        if (arg == null) {
            return new String[0];
        }
        ArrayList result = new ArrayList();
        for (StringTokenizer token = new StringTokenizer(arg, "/"); token
                .hasMoreTokens();) {
            String next = token.nextToken();
            if (next == null) {
                break;
            }
            result.add(next);
        }
        return (String[]) result.toArray(new String[result.size()]);
    }
}