/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.field;

import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public class ConstantField extends FieldExpander {

	public ConstantField(Class type, String name, String constantValue) {
		this(new Type(type), name, constantValue);
	}

	public ConstantField(Type type, String name, String constantValue) {
		this(new Value(type, name), constantValue);
	}

	public ConstantField(Value value, String constantValue) {
		this(value);
		setLiteralValue(constantValue);
	}

	public ConstantField(Class type, String name) {
		this(new Type(type), name);
	}

	public ConstantField(Type type, String name) {
		this(new Value(type, name));
	}

	public ConstantField(Value value) {
		super(value, new NameAdjuster().toConstantFieldName(value.getName()));
		setScope(Scope.PUBLIC);
		setStatic(true);
		setFinal(true);
	}
}
