/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.javadoc;

import java.util.ArrayList;
import java.util.List;

import blanco.ig.expander.Expander;


/**
 * @author Yasuo Nakanishi
 */
public abstract class JavaDoc implements Expander {
    private List _docLine = null;

    public JavaDoc(){
        _docLine = new ArrayList();
    }
    
    public boolean isEmpty(){
        return _docLine.size() == 0;
    }
    
    public void addLine(String doc) {
        _docLine.add(doc);
    }

    public abstract void expandJavaDoc();
    
    public List expand() {
        List result = new ArrayList();
        
        expandJavaDoc();
        
        if(_docLine.size() == 1){
            StringBuffer sb = new StringBuffer();
            sb.append("/**\t");
            sb.append(_docLine.get(0));
            sb.append("\t*/");
            result.add(new String(sb));
        } else if(_docLine.size() > 1){
            result.add("/**");
            for(int i = 0; i < _docLine.size(); i++){
                result.add(" *\t" + _docLine.get(i));
            }
            result.add(" */");
        }
        return result;
    }
}
