/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.tool;

import java.util.Hashtable;
import java.util.Map;

import blanco.ig.service.ObjectClass;
import blanco.ig.service.ServiceClass;

/**
 * @author Yasuo Nakanishi
 */
public class BaseObjectStorage {
    private Map _storage = new Hashtable();
    private ServiceClass _serviceClass = null;
    
    public BaseObjectStorage(ServiceClass serviceClass) {
        _serviceClass = serviceClass;
    }
    
    public void regist(ObjectClass objectClass, String name, Object object) {
        _storage.put(getKey(objectClass, name), object);
    }

    public void regist(String name, Object object) {
        _storage.put(getKey(_serviceClass, name), object);
    }
    
    protected Object get(ObjectClass objectClass, String name) {
        return _storage.get(getKey(objectClass, name));
    }
    
    protected Object get(String name) {
        return _storage.get(getKey(_serviceClass, name));
    }
    
    private String getKey(ObjectClass objectClass, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(objectClass.getKey());
        sb.append(",");
        sb.append(name);
        return sb.toString();
    }

    private String getKey(ServiceClass serviceClass, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(serviceClass.getKey());
        sb.append(",");
        sb.append(name);
        return sb.toString();
    }
    
    public ServiceClass getServiceClass() {
        return _serviceClass;
    }
}
