/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel;

/**
 * @author Yasuo Nakanishi
 */
public class CellParser {

    public static CellPointer parse(String address) {
        int column = parseColumnNumber(address);
        int row = parseRowNumber(address);
        return new CellPointer(column, row, address);
    }

    public static CellPointer toAddress(int column, int row) {
        String pointer = toString(column, row);
        return new CellPointer(column, row, pointer);
    }

    public static String toString(int column, int row) {
        return numberToColumn(column) + Integer.toString(row + 1);
    }

    public static int parseColumnNumber(String cell) {
        String hex = cell.split("[0-9]+")[0];
        return columnToNumber(hex);
    }

    public static int parseRowNumber(String cell) {
        String row = cell.split("[a-zA-Z]+")[1];
        return (Short.parseShort(row) - 1);
    }

    private static int columnToNumber(String hex) {
        int result = 0;
        StringBuffer sb = new StringBuffer(hex);
        for (int i = 0; i < sb.length(); i++) {
            result *= 26;
            result += Integer.parseInt(hex.substring(i, i + 1), 36) - 9;
        }
        return result - 1;
    }

    public static String numberToColumn(int column) {
        StringBuffer sb = new StringBuffer();
        int remain = column;
        int value = 0;

        while (true) {
            value = remain % 26;
            sb.insert(0, Integer.toString(value + 10, 36).toUpperCase());
            remain = (remain / 26) - 1;
            if (remain == -1) {
                break;
            }
        }

        return sb.toString();
    }
}
