/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel;

/**
 * @author Yasuo Nakanishi
 */
public class CellRangeParser {

    private CellPointer _startPointer = null;

    private CellPointer _endPointer = null;

    public CellRangeParser(String cellRange) {
        parse(cellRange);
    }

    private void parse(String cellRange) {
        String cells[] = cellRange.split("[:]");

        _startPointer = CellParser.parse(cells[0]);
        _endPointer = CellParser.parse(cells[1]);
    }

    public int getRowCount() {
        return _endPointer.getRow() - _startPointer.getRow() + 1;
    }

    public int getColumnCount() {
        return _endPointer.getColumn() - _startPointer.getColumn() + 1;
    }

    public CellPointer getEndPointer() {
        return _endPointer;
    }

    public CellPointer getStartPointer() {
        return _startPointer;
    }
}
