/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel.oo;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

import blanco.api.excel.ExcelBook;
import blanco.api.excel.ExcelSheet;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.UnoRuntime;

/**
 * @author Yasuo Nakanishi
 */
public class OoExcelBook implements ExcelBook {
    private CalcService _service = null;

    private XComponent _component;

    private XSpreadsheetDocument _document;

    public OoExcelBook(CalcService service, XComponent component) {
        _service = service;
        _component = component;
    }

    public void copySheet(String source, String distination, short position) {
        XSpreadsheets sheets = getSheets();
        sheets.copyByName(source, distination, (short) position);
    }

    public void copySheet(String source, String distination) {
        short index = (short) getSheets().getElementNames().length;
        copySheet(source, distination, index);
    }

    public void saveAs(String path) throws java.io.IOException {
        XStorable sotreble = _service.getStorable(_component);

        PropertyValue[] storeProps = new PropertyValue[1];
        storeProps[0] = new PropertyValue();
        storeProps[0].Name = "FilterName";
        storeProps[0].Value = "MS Excel 97";
        try {
            String url = new File(path).toURL().toString();
            sotreble.storeAsURL(url, storeProps);
        } catch (IOException e) {
            throwIOException(e);
        }
    }

    public void saveToPdf(String path) throws java.io.IOException {
        XStorable sotreble = _service.getStorable(_component);

        PropertyValue[] storeProps = new PropertyValue[1];
        storeProps[0] = new PropertyValue();
        storeProps[0].Name = "FilterName";
        storeProps[0].Value = "calc_pdf_Export";
        try {
            String url = new File(path).toURL().toString();
            sotreble.storeToURL(url, storeProps);
        } catch (IOException e) {
            throwIOException(e);
        }
    }

    public void save() throws java.io.IOException {
        XStorable sotreble = _service.getStorable(_component);
        try {
            sotreble.store();
        } catch (IOException e) {
            throwIOException(e);
        }
    }

    private void throwIOException(IOException e) throws java.io.IOException {
        java.io.IOException exception = new java.io.IOException();
        exception.initCause(e);
        throw exception;
    }

    public void close() {
        _component.dispose();
    }

    public ExcelSheet createSheet(String name) {
        XSpreadsheets sheets = getSheets();
        short index = (short) sheets.getElementNames().length;
        sheets.insertNewByName(name, index);

        return getSheet(name);
    }

    private XSpreadsheetDocument getDocument() {
        if (_document == null) {
            _document = (XSpreadsheetDocument) UnoRuntime.queryInterface(
                    XSpreadsheetDocument.class, _component);
        }
        return _document;
    }

    private XSpreadsheets getSheets() {
        return getDocument().getSheets();
    }

    public ExcelSheet getSheet(String name) {
        XSpreadsheets sheets = getSheets();
        Object o = null;
        try {
            o = getSheets().getByName(name);
        } catch (Exception e) {
            String message = "V[g̎擾ɎsBV[g:" + name;
            throw new RuntimeException(message);
        }
        return createSheet(o);
    }

    public ExcelSheet createSheet(Object sheetObject) {
        assert sheetObject != null;
        ExcelSheet result = null;
        XSpreadsheet sheet = (XSpreadsheet) UnoRuntime.queryInterface(
                XSpreadsheet.class, sheetObject);
        result = new OoExcelSheet(_service, this, sheet);
        return result;
    }

    public ExcelSheet getSheet(short position) {
        String name = getSheets().getElementNames()[position];
        return getSheet(name);
    }

    public void removeSheet(String name) {
        XSpreadsheets sheets = getSheets();
        try {
            sheets.removeByName(name);
        } catch (NoSuchElementException e) {
            String message = "V[g̍폜Ɏs܂BV[g:" + name;
            throw new RuntimeException(message, e);
        } catch (WrappedTargetException e) {
            String message = "V[g̍폜Ɏs܂BV[g:" + name;
            throw new RuntimeException(message, e);
        }
    }

    public String getFilePath() {
        String url = _service.getModel(_document).getURL();
        String result = "";
        try {
            result = new File(new URI(url)).getAbsolutePath();
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public int getSheetCount() {
        return _service.getIndexAccess(getSheets()).getCount();
    }

    public boolean hasSheet(String name) {
        boolean result = false;
        XSpreadsheets sheets = getSheets();
        try {
            getSheets().getByName(name);
            result = true;
        } catch (Exception e) {
        }
        return result;
    }
}
