/*
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:  
 *    "This product includes software developed by the 
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements 
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission of 
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT 
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package blanco.api.oo.launchar;

import java.io.File;
import java.io.IOException;

import org.apache.log4j.Logger;

import blanco.api.oo.uno.UnoService;

/**
 * OOoLauncher (OpenOffice.org `[NX)
 * 
 * ̃vÓAOpenOffice.org풓̃`vOłB <br>
 * OpenOffice.org풓̋NEIS܂B OpenOffice.org 1.1.4 {+Windows XP
 * SP2œmF܂B <br>
 * ̃vOWindows XPȍ~ŗLł (Windows XP TASKKILLR}h𗘗pĂ܂) <br>
 * I[v\[X(Seasar Software License)̂ƂŌJĂ S2Joo x[XɃJX^}CYč쐬܂B <br>
 * ̂߁ACZX́uThe Seasar Software License, Version 1.1vɏ܂B
 * 
 * : {IɃXbhZ[tł́u܂vBȂȂ瑊肪vZXł邩łB̃NX̗p҂VOœ삷悤ɐ䂵ĂB
 * 
 * @author makotan: http://d.hatena.ne.jp/makotan/ (IWi)
 * @author igapyon: tosiki.iga@nifty.ne.jp (HĒ܂)
 * @author Yasuo Nakanishi
 * @version 2005/03/04 OOoLaunchero[W쐬
 */
public class OOoLauncher {

    // TODO getClassLogger쐬Ó̌؂sĂ܂B
    private Logger _logger = Logger.getLogger(getClass());

    private String _openOfficeExecuteFile = "";

    /**
     * OOoNOOo\邩ǂtO
     */
    private boolean _hide = true;

    /**
     * OpenOffice.orgNƂ̑ҋ@Ԃw肵܂B
     */
    public static final int WAIT_MILLISEC_FOR_SOFFICE_LAUNCH = 1000;

    /**
     * OpenOffice.orgKILLƂ̑ҋ@Ԃw肵܂B
     */
    private static final int WAIT_MILLISEC_FOR_SOFFICE_KILL = 1000;

    /**
     * OpenOffice.org̃vZXL܂B staticϐƂĕێOOoN`FbNpϐB <br>
     * ӁF̕ϐstaticϐłI <br>
     * ӂQF̕ϐɑ΂synchronizedĂȂǁAdloOB
     */
    private static Process _process = null;

    /**
     * OOo̐ڑ|[gԍ܂B
     */
    private int _port = 8100;

    /**
     * OpenOffice.orgT[oƂċN邽߂̈B Windows̏ꍇSolaris̏ꍇB
     */
    private String _unoArgument = null;

    /**
     * OpenOffice.orgvZX~邽߂̃R}hB
     */
    // Solaris̏ꍇ
    //    public static final String[] OOO_KILL = { "pkill", "soffice" };
    // Windows̏ꍇ
    public static final String[] OOO_KILL = { "taskkill.exe", "/f", "/im",
            "soffice.exe" };

    public OOoLauncher(String executeFile) {
        this(executeFile, 8100);
    }

    public OOoLauncher(String executeFile, int port) {
        this(executeFile, port, true);
    }

    /**
     * OpenOffice.orgNNX̃RXgN^B
     * 
     * @param executeFile
     *            OpenOffice.org̃W[pX <br>
     *            <code>
     *            ex. ["C:\\Program Files\\OpenOffice.org1.1.4\\program\\soffice.exe"]<code>
     * @param port
     * @param hide
     */
    public OOoLauncher(String executeFile, int port, boolean hide) {
        _openOfficeExecuteFile = executeFile;
        _port = port;
        _hide = hide;

        StringBuffer sb = new StringBuffer();
        sb.append("-accept=socket");
        sb.append(",port=");
        sb.append(port);
        sb.append(";urp;");
        _unoArgument = sb.toString();

        // TODO ServiceManagerw̗L͌Kv:
        // -accept=socket,port=8100;urp;StarOffice.ServiceManager
    }

    /**
     * OpenOffice.orgvZXN܂B <br>
     * O ensureStop()ĂяoĂƁAmłƍl܂B
     *  
     */
    public void start() {
        for (;;) {
            // ̃vZXp̂ҋ@c
            // |CgF_processstaticϐI
            synchronized (OOoLauncher.class) {
                if (_process == null) {
                    break;
                }
            }
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                // ҋ@̊荞݂͖܂B
                e.printStackTrace();
                break;
            }
        }

        synchronized (OOoLauncher.class) {
            File fileCheck = new File(_openOfficeExecuteFile);
            if (fileCheck.exists() == false) {
                throw new IllegalArgumentException("OpenOffice.org[hW[ ["
                        + fileCheck + "] ̃t@C܂ł.");
            }

            try {
                _logger.debug("Start OpenOffice.org [" + _openOfficeExecuteFile
                        + "].");

                String[] commands = null;
                if (_hide) {
                    commands = new String[] { _openOfficeExecuteFile,
                            "-invisible", _unoArgument };
                } else {
                    commands = new String[] { _openOfficeExecuteFile,
                            _unoArgument };
                }

                _process = Runtime.getRuntime().exec(commands);
                waitBootUp();
            } catch (IOException ex) {
                _logger.error("Start OpenOffice.org [" + _openOfficeExecuteFile
                        + "] is failed: " + ex.toString());
                ex.printStackTrace();
            }
        }
    }

    /**
     * OOovZX̋NmF郁\bhB <br>
     * TODO ƂāA\PbgɂNmFVXeIɈSǂ̑Ó؂KvB
     */
    protected void waitBootUp() {
        long start = System.currentTimeMillis();

        // TODO ϐŃ^CAEglێ͕sKB
        long timeOut = 60000;
        while (true) {
            try {
                Thread.sleep(WAIT_MILLISEC_FOR_SOFFICE_LAUNCH);
            } catch (InterruptedException ex) {
                System.out.println("OpenOfficevZXN̋K莞Ԃ̑ҋ@Ɋ荞݂܂.: "
                        + ex.toString());
                ex.printStackTrace();
            }

            // NmFs܂B
            UnoService _service = new UnoService("localhost", _port, true);
            try {
                _service.connect();
                _service.close();
                break;
            } catch (Exception e) {
                e.printStackTrace();
            }

            long now = System.currentTimeMillis();
            if (now > start + timeOut) {
                String message = "UnoService̋N`FbNŃ^CAEg܂B";
                throw new RuntimeException(message);
            }
        }
    }

    /**
     * OpenOffice.orgvZX~Ă邱Ƃ̔O܂B
     */
    public void ensureStop() {
        try {
            // TASKKILLpH
            Process procKill = Runtime.getRuntime().exec(OOO_KILL);
            procKill.waitFor();
        } catch (IOException ex1) {
            System.out
                    .println("OpenOffice.org̋~R}h ["
                            + OOO_KILL
                            + "] s܂B"
                            + "Windows 2000ȑOOSɂāATASKKILLR}h͎ĂȂ̂ŁÃR}h͎s܂B");
        } catch (InterruptedException ex) {
            System.out
                    .println("OpenOfficevZX~R}h̋N̋K莞Ԃ̑ҋ@Ɋ荞݂܂.: "
                            + ex.toString());
            ex.printStackTrace();
        }
    }

    /**
     * OpenOffice.orgvZX~܂B
     */
    public void stop() {
        synchronized (OOoLauncher.class) {

            if (_process == null) {
                return;
            }
            _logger.debug("Stop OpenOffice.org [" + _openOfficeExecuteFile
                    + "].");

            _process.destroy();

            try {
                // DestoryAwbҋ@܂B
                Thread.sleep(WAIT_MILLISEC_FOR_SOFFICE_KILL);
            } catch (InterruptedException ex1) {
                // sleep̗O͖܂B
                System.out
                        .println("OpenOfficevZX~˗s̋K莞Ԃ̑ҋ@Ɋ荞݂܂.: "
                                + ex1.toString());
                ex1.printStackTrace();
            }

            // mɒ~܂B
            ensureStop();

            int retcode = -1;
            try {
                // OpenOffice.orgvZX̊S~mF܂B
                retcode = _process.waitFor();
                System.out.println("OpenOfficevZX ߂l[" + retcode
                        + "]ŏI܂.");
            } catch (InterruptedException ex) {
                // waitFor̗O͖܂B
                ex.printStackTrace();
                _logger.error("Stop OpenOffice.org [" + _openOfficeExecuteFile
                        + "] is failed: " + ex.toString());
            }
            // 傤Ȃ̂ŁAO̓vZX~Ƃ܂B
            _process = null;
        }
    }

    public final boolean isAlive() {
        synchronized (OOoLauncher.class) {
            return (_process != null);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        synchronized (OOoLauncher.class) {
            if (_process != null) {
                System.out
                        .println("UnoServerLauncher#stop()\bhĂ΂܂łBKstop()\bhĂԂ悤ɂĂB");
                stop();
            }
        }
    }
}
