/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.oo.uno;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

/**
 * @author Yasuo Nakanishi
 */
public class UnoService {
    private Object _desktop = null;

    private XConnection _connection = null;

    private String _connectionString = "";

    private boolean _hide = true;

    public UnoService(String host, int port) {
        StringBuffer sb = new StringBuffer("socket,host=localhost,port=");
        sb.append(port);
        sb.append(",tcpNoDelay=1");
        _connectionString = sb.toString();
    }

    public UnoService(String host, int port, boolean hide) {
        StringBuffer sb = new StringBuffer("socket,host=localhost,port=");
        sb.append(port);
        sb.append(",tcpNoDelay=1");
        _connectionString = sb.toString();
        _hide = hide;
    }

    public void connect() {
        XBridge bridge = createBridge();
        _desktop = createDesktopInstance(bridge);
    }

    private Object getDesktop() {
        return _desktop;
    }

    protected XComponentLoader getComponentLoader() {
        return (XComponentLoader) getInterface(XComponentLoader.class,
                getDesktop());
    }

    protected XStorable getStorable(XComponent component) {
        return (XStorable) getInterface(XStorable.class, component);
    }

    protected XDesktop getDesktopInterface() {
        return (XDesktop) getInterface(XDesktop.class, _desktop);
    }

    public boolean isAvailable() {
        return _connection != null;
    }

    public void close() {
        if (_connection != null) {
            try {
                _connection.close();
                _connection = null;
            } catch (IOException e) {
                String message = "UNOւ̐ؒfɎs܂B";
                IOException ioe = new IOException(message, e);
                ioe.printStackTrace();
            }
        }
    }

    protected static Object getInterface(Class type, Object instance) {
        return UnoRuntime.queryInterface(type, instance);
    }

    protected XBridge createBridge() {
        try {
            XComponentContext localContext = Bootstrap
                    .createInitialComponentContext(null);
            XMultiComponentFactory localServiceManager = localContext
                    .getServiceManager();
            Object context = localServiceManager.createInstanceWithContext(
                    "com.sun.star.connection.Connector", localContext);
            XConnector connector = (XConnector) getInterface(XConnector.class,
                    context);
            try {
                _connection = connector.connect(_connectionString);
            } catch (NoConnectException e) {
                String message = "UNOڑɎs܂B";
                throw new RuntimeException(message, e);
            } catch (ConnectionSetupException e) {
                String message = "UNOڑ̃ZbgAbvɎs܂B";
                throw new RuntimeException(message, e);
            }

            context = localServiceManager.createInstanceWithContext(
                    "com.sun.star.bridge.BridgeFactory", localContext);
            XBridgeFactory bridgeFactory = (XBridgeFactory) getInterface(
                    XBridgeFactory.class, context);
            return bridgeFactory.createBridge("", "urp", _connection, null);
        } catch (Exception e) {
            String message = "ubW̍쐬Ɏs܂B";
            throw new RuntimeException(message, e);
        }
    }

    protected Object createDesktopInstance(XBridge bridge) {
        try {
            XMultiComponentFactory serviceManager = (XMultiComponentFactory) getInterface(
                    XMultiComponentFactory.class, bridge
                            .getInstance("StarOffice.ServiceManager"));
            XPropertySet propertySet = (XPropertySet) getInterface(
                    XPropertySet.class, serviceManager);
            XComponentContext remoteContext = (XComponentContext) getInterface(
                    XComponentContext.class, propertySet
                            .getPropertyValue("DefaultContext"));
            XMultiComponentFactory remoteServiceManager = remoteContext
                    .getServiceManager();
            return remoteServiceManager.createInstanceWithContext(
                    "com.sun.star.frame.Desktop", remoteContext);
        } catch (Exception e) {
            String message = "fXNgbvCX^X̍쐬Ɏs܂B";
            throw new RuntimeException(message, e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();

        if (_connection != null) {
            _connection.close();
            _connection = null;

            System.err.println("UnoService#close()\bhĂ΂܂łB"
                    + "̃\bh͕KĂ΂悤ɎĂB");
        }
    }

    protected boolean isHide() {
        return _hide;
    }

    public XComponent loadComponent(String url) throws java.io.IOException {
        PropertyValue[] properties = new PropertyValue[1];
        properties[0] = new PropertyValue();
        properties[0].Name = "Hidden";
        properties[0].Value = new Boolean(_hide);

        XComponentLoader loader = getComponentLoader();
        XComponent result = null;
        try {
            result = loader.loadComponentFromURL(url, "_blank", 0, properties);
        } catch (IOException e) {
            throwIOException(e);
        } catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void store(XComponent component, String url,
            PropertyValue[] properties) throws java.io.IOException {
        XStorable sotreble = getStorable(component);

        try {
            sotreble.storeAsURL(url, properties);
        } catch (IOException e) {
            throwIOException(e);
        }
    }

    private void throwIOException(IOException e) throws java.io.IOException {
        java.io.IOException exception = new java.io.IOException();
        exception.initCause(e);
        throw exception;
    }
}
