/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.collector;

import blanco.api.excel.CellPointer;
import blanco.api.excel.ExcelSheet;

/**
 * @author Yasuo Nakanishi
 */
public class FormSetSpecificationParser {
    private ExcelSheet _sheet = null;

    private CellPointer _reportNameCell = new CellPointer("B3");

    private CellPointer _jpNameCell = new CellPointer("B4");

    private CellPointer _classPackageCell = new CellPointer("B7");

    private CellPointer _classNameCell = new CellPointer("B8");

    private CellPointer _classDescriptionCell = new CellPointer("B9");

    private CellPointer _outputTypeCell = new CellPointer("B13");

    public FormSetSpecificationParser(ExcelSheet sheet) {
        _sheet = sheet;
    }

    public void parse() throws Exception {

    }

    public String getClassDescription() {
        return _sheet.getText(_classDescriptionCell);
    }

    public void setClassDescriptionCell(CellPointer classDescriptionCell) {
        _classDescriptionCell = classDescriptionCell;
    }

    public String getClassName() {
        return _sheet.getText(_classNameCell);
    }

    public void setClassNameCell(CellPointer classNameCell) {
        _classNameCell = classNameCell;
    }

    public String getClassPackage() {
        return _sheet.getText(_classPackageCell);
    }

    public void setClassPackageCell(CellPointer classPackageCell) {
        _classPackageCell = classPackageCell;
    }

    public String getOutputType() {
        return _sheet.getText(_outputTypeCell);
    }

    public void setOutputTypeCell(CellPointer outputTypeCell) {
        _outputTypeCell = outputTypeCell;
    }

    public String getJpName() {
        return _sheet.getText(_jpNameCell);
    }

    public void setReportJpNameCell(CellPointer reportJpNameCell) {
        _jpNameCell = reportJpNameCell;
    }

    public String getReportName() {
        return _sheet.getText(_reportNameCell);
    }

    public void setReportNameCell(CellPointer reportNameCell) {
        _reportNameCell = reportNameCell;
    }

    public ExcelSheet getSheet() {
        return _sheet;
    }

    public void setSheet(ExcelSheet sheet) {
        _sheet = sheet;
    }
}
