/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.collector;

import blanco.api.excel.ExcelBook;

/**
 * @author Yasuo Nakanishi
 */
public class FormSetSpecificationValidator {
    private ExcelBook _book = null;

    private FormSetSpecificationParser _parser = null;

    public FormSetSpecificationValidator(ExcelBook book,
            FormSetSpecificationParser parser) {
        _book = book;
        _parser = parser;
    }

    public void validate() {
        String value = "";
        value = _parser.getReportName();
        if (value.equals("")) {
            String message = "[w肳Ă܂BubN:";
            message += _book.getFilePath();
            message += ",V[g:";
            message += _parser.getSheet().getName();
            throw new RuntimeException(message);
        }

        value = _parser.getOutputType();
        if (value.equals("")) {
            String message = "o͌`w肳Ă܂BubN:";
            message += _book.getFilePath();
            message += ",V[g:";
            message += _parser.getSheet().getName();
            throw new RuntimeException(message);
        }
    }
}
