/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.collector;

import java.math.BigDecimal;
import java.util.Date;

import blanco.api.excel.CellType;
import blanco.api.excel.ExcelBook;
import blanco.api.excel.ExcelSheet;
import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;
import blanco.report.definition.FieldSpecification;
import blanco.report.definition.FormDataStruct;
import blanco.report.definition.FormSpecification;

/**
 * @author Yasuo Nakanishi
 */
public class FormSpecificationCollector {
    private ExcelBook _formSetBook = null;

    private ExcelBook _specificationBook = null;

    private ExcelSheet _sheet = null;

    private String _rootNameSpace = "";

    private FormSpecificationParser _parser = null;

    private FormSpecification _result = null;

    public FormSpecificationCollector(ExcelBook formSetBook,
            ExcelBook specificationBook, ExcelSheet sheet, String rootNameSpace) {
        assert sheet != null;
        _formSetBook = formSetBook;
        _specificationBook = specificationBook;
        _sheet = sheet;
        _rootNameSpace = rootNameSpace;
        _parser = new FormSpecificationParser(_sheet);
    }

    public void parse() throws Exception {
        _parser.parse();
    }

    public void validate() {
        FormSpecificationValidator validator = new FormSpecificationValidator(
                _formSetBook, _specificationBook, _parser);
        validator.validate();
    }

    public FormSpecification collect() {
        _result = new FormSpecification(_parser.getFormName());
        _result.setEndAddress(_parser.getEndCellAddress());

        String value = _parser.getBlockCountPerPage();
        if (!value.equals("")) {
            int blocks = Integer.parseInt(value);
            _result.setBlockCountPerPage(blocks);

        }

        collectBlocks();
        collectDataStruct();

        return _result;
    }

    private void collectBlocks() {
        String name = "";
        String range = "";
        for (int i = 0; _parser.exsistBlock(i); i++) {
            name = _parser.getBlockName(i);
            range = _parser.getBlockRange(i);
            _result.addBlock(name, range);
        }
    }

    public void collectDataStruct() {
        String name = "";
        String range = "";
        Type type = null;

        String sheetName = _sheet.getName();
        FormDataStruct dataStruct = new FormDataStruct(sheetName);
        dataStruct.setClassType(getType(sheetName));
        FieldSpecification specification = null;
        String blockName = "";
        for (int i = 0; _parser.exsistField(i); i++) {
            if (!_parser.isBlockField(i)) {
                dataStruct.addField(getField(i));
            } else {
                blockName = _parser.getFieldBlock(i);
                dataStruct.getBlockItem(blockName).addField(getField(i));
            }
        }
        assert dataStruct != null;
        _result.setDataStruct(dataStruct);
    }

    private FieldSpecification getField(int index) {
        FieldSpecification result = null;

        String name = _parser.getFieldName(index);
        CellType cellType = _parser.getFieldCellType(index);
        Type type = getFielType(cellType);

        result = new FieldSpecification(name, type);
        result.setJpName(_parser.getFieldJpName(index));
        result.setBlock(_parser.getFieldBlock(index));
        result.setCellType(cellType);
        return result;
    }

    private Type getFielType(CellType type) {
        Type result = null;
        if (type.equals(CellType.TEXT)) {
            result = new Type(String.class);
        } else if (type.equals(CellType.NUMBER)) {
            result = new Type(BigDecimal.class);
        } else if (type.equals(CellType.DATE)) {
            result = new Type(Date.class);
        }
        return result;
    }

    private Type getType(String name) {
        String packageName = _parser.getClassPackage();
        NameAdjuster adjuster = new NameAdjuster();
        if (packageName.equals("")) {
            packageName = _rootNameSpace;
        }
        String className = _parser.getClassName();
        if (className.equals("")) {
            className = adjuster.toClassName(_parser.getFormName())
                    + "PageData";
        }
        return new Type(packageName, className);
    }
}
