/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.collector;

import blanco.api.excel.CellPointer;
import blanco.api.excel.CellType;
import blanco.api.excel.ExcelSheet;

/**
 * @author Yasuo Nakanishi
 */
public class FormSpecificationParser {

    private ExcelSheet _sheet = null;

    private CellPointer _formNameCell = new CellPointer("B3");

    private CellPointer _formJpNameCell = new CellPointer("B4");

    private CellPointer _classPackageCell = new CellPointer("B7");

    private CellPointer _classNameCell = new CellPointer("B8");

    private CellPointer _classDescriptoinCell = new CellPointer("B9");

    private CellPointer _endCell = new CellPointer("B13");

    private CellPointer _blockCountPerPageCell = new CellPointer("B14");

    private CellPointer _blockBaseCell = new CellPointer("A18");

    private CellPointer _fieldBaseCell = new CellPointer("A23");

    private CellPointer _fieldStartCell = new CellPointer("A23");

    public FormSpecificationParser(ExcelSheet sheet) {
        _sheet = sheet;
    }

    public void parse() throws Exception {
        _fieldStartCell = findFieldStart();
    }

    private CellPointer findFieldStart() {
        CellPointer result = null;
        String label = "ytB[h`z";
        String value = "";
        for (int i = _fieldBaseCell.getRow(); true; i++) {
            value = _sheet.getText(0, i);
            if (value.equals(label)) {
                result = new CellPointer(0, i + 2);
                break;
            }
            if (_sheet.getText(_fieldBaseCell.move(0, i)).equals("")) {
                break;
            }
        }
        if (result == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("ReportForm`̃V[gtH[}bgƈv܂B");
            sb.append("x\"" + label + "\"̕V[gɌ܂łB");
            sb.append("ubN:" + _sheet.getBook().getFilePath());
            sb.append("AV[gF" + _sheet.getName());
        }
        return result;
    }

    public String getFormName() {
        return _sheet.getText(_formNameCell);
    }

    public String getFormJpName() {
        return _sheet.getText(_formJpNameCell);
    }

    public String getBlockCountPerPage() {
        return _sheet.getText(_blockCountPerPageCell);
    }

    public String getClassDescriptoin() {
        return _sheet.getText(_classDescriptoinCell);
    }

    public String getClassName() {
        return _sheet.getText(_classNameCell);
    }

    public String getClassPackage() {
        return _sheet.getText(_classPackageCell);
    }

    public String getEndCellAddress() {
        return _sheet.getText(_endCell);
    }

    private CellPointer getBlockCell(int blockIndex) {
        return _blockBaseCell.move(0, blockIndex);
    }

    public String getBlockName(int blockIndex) {
        return _sheet.getText(getBlockCell(blockIndex));
    }

    public String getBlockRange(int blockIndex) {
        return _sheet.getText(getBlockCell(blockIndex).move(1, 0));
    }

    public boolean exsistBlock(int blockIndex) {
        boolean result = false;
        String name = _sheet.getText(getBlockCell(blockIndex));
        if (!name.equals("")) {
            result = true;
        }
        return result;
    }

    private CellPointer getFieldCell(int fieldIndex) {
        return _fieldStartCell.move(0, fieldIndex);
    }

    public boolean exsistField(int fieldIndex) {
        boolean result = false;
        String name = getFieldName(fieldIndex);
        if (!name.equals("")) {
            result = true;
        }
        return result;
    }

    public String getFieldName(int fieldIndex) {
        return _sheet.getText(getFieldCell(fieldIndex).move(0, 0));
    }

    public String getFieldJpName(int fieldIndex) {
        return _sheet.getText(getFieldCell(fieldIndex).move(1, 0));
    }

    public String getFieldBlock(int fieldIndex) {
        return _sheet.getText(getFieldCell(fieldIndex).move(2, 0));
    }

    public CellType getFieldCellType(int fieldIndex) {
        CellType result = null;
        String type = _sheet.getText(getFieldCell(fieldIndex).move(3, 0));
        if (type.equals("eLXg")) {
            result = CellType.TEXT;
        } else if (type.equals("l")) {
            result = CellType.NUMBER;
        } else if (type.equals("t")) {
            result = CellType.DATE;
        } else {
            String message = "sȃZ̎ނw肳܂BZ̎:" + type;
            throw new RuntimeException(message);
        }
        return result;
    }

    public boolean isBlockField(int fieldIndex) {
        return !getFieldBlock(fieldIndex).equals("");
    }

    public ExcelSheet getSheet() {
        return _sheet;
    }
}
