/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.definition;

import blanco.api.excel.CellType;
import blanco.core.datastruct.DataStructField;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public class FieldSpecification extends DataStructField {

    private String _jpName = "";

    private String _block = "";

    private CellType _cellType = CellType.TEXT;

    public FieldSpecification(String name, Type type) {
        super(new Value(type, name));
    }

    public String getBlock() {
        return _block;
    }

    public void setBlock(String block) {
        _block = block;
    }

    public String getJpName() {
        return _jpName;
    }

    public void setJpName(String jpName) {
        _jpName = jpName;
    }

    public CellType getCellType() {
        return _cellType;
    }

    public void setCellType(CellType type) {
        _cellType = type;
    }
}
