/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.definition;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import blanco.core.datastruct.DataStructDefinition;
import blanco.ig.expander.Type;

/**
 * @author Yasuo Nakanishi
 */
public class FormDataStruct extends DataStructDefinition {

    private String _formName = "";

    private Type _classType = null;

    private String _classDescription = "";

    private List _formLists = new ArrayList();

    private Map _formListMap = new Hashtable();

    public FormDataStruct(String sheetName) {
        super(sheetName);
        _formName = sheetName.replaceFirst("Specification", "");
    }

    public void addList(BlockItem listItem) {
        _formLists.add(listItem);
        _formListMap.put(listItem.getName(), listItem);
    }

    public Iterator getBlocksIterator() {
        return _formLists.iterator();
    }

    public BlockItem getBlockItem(String name) {
        if (!_formListMap.containsKey(name)) {
            BlockItem item = new BlockItem(name);
            String className = _formName + name + "Block";
            Type type = new Type(_classType.getNameSpace(), className);
            item.setClassType(type);
            _formLists.add(item);
            _formListMap.put(name, item);
        }
        return (BlockItem) _formListMap.get(name);
    }

    public Type getClassType() {
        return _classType;
    }

    public void setClassType(Type classType) {
        _classType = classType;
    }

    public String getClassDescription() {
        return _classDescription;
    }

    public void setClassDescription(String classDescription) {
        _classDescription = classDescription;
    }

    public String getFormName() {
        return _formName;
    }
}
