/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.expander.form.datastruct;

import java.util.Iterator;

import blanco.core.datastruct.DataStructClass;
import blanco.ig.expander.Type;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;
import blanco.report.definition.BlockItem;
import blanco.report.definition.FieldSpecification;

/**
 * @author Yasuo Nakanishi
 */
public class BlockClass extends DataStructClass {

    private BlockItem _blockItem = null;

    public BlockClass(Type type, BlockItem blockItem) {
        super(type, blockItem);
        _blockItem = blockItem;
    }

    public static String createName(String name) {
        return getNameAdjuster().toClassName(name) + "Block";
    }

    protected void expandClassStruct() {
        super.expandClassStruct();

        FieldExpander field = null;
        FieldSpecification fieldSpecification = null;
        Iterator iterator = _blockItem.getFieldIterator();
        Statement s = null;
        while (iterator.hasNext()) {
            fieldSpecification = (FieldSpecification) iterator.next();
            field = getField(fieldSpecification.getValue().getName());
        }

        String doc = "";
        doc = _blockItem.getName() + " ubÑf[^\NXłB";
        getJavaDoc().addLine(doc);
    }
}
