/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.expander.form.datastruct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.core.datastruct.AddListItemMethod;
import blanco.core.datastruct.DataStructClass;
import blanco.core.datastruct.GetListIteratorMethod;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.field.PrivateField;
import blanco.ig.expander.implementor.Call;
import blanco.report.definition.BlockItem;
import blanco.report.definition.FieldSpecification;
import blanco.report.definition.FormDataStruct;

/**
 * @author Yasuo Nakanishi
 */
public class PageDataClass extends DataStructClass {
    private FormDataStruct _formDataStruct = null;

    public PageDataClass(Type type, FormDataStruct dataStruct) {
        super(type, dataStruct);
        _formDataStruct = dataStruct;
    }

    public static String createName(String name) {
        return getNameAdjuster().toClassName(name) + "PageData";
    }

    protected void expandClassStruct() {
        super.expandClassStruct();

        Iterator iterator = null;
        BlockItem item = null;
        String name = "";
        Value value = null;
        FieldExpander field = null;
        Type type = null;

        FieldSpecification fieldSpecification = null;
        iterator = _formDataStruct.getFieldIterator();
        while (iterator.hasNext()) {
            fieldSpecification = (FieldSpecification) iterator.next();
            field = getField(fieldSpecification.getValue().getName());
        }

        iterator = _formDataStruct.getBlocksIterator();
        String listName = "";
        while (iterator.hasNext()) {
            item = (BlockItem) iterator.next();
            name = item.getName();
            listName = createListName(item.getName());
            type = item.getClassType();

            field = new PrivateField(new Value(List.class, listName));
            field.setDefaultStatement(new Call(ArrayList.class));
            addField(field);
            addMethod(new AddListItemMethod(name + "Block", listName, type));
            addMethod(new GetListIteratorMethod(name, listName));
        }

        String doc = "";
        doc = _formDataStruct.getFormName() + " y[W̃f[^\NXB";
        getJavaDoc().addLine(doc);

        doc = _formDataStruct.getClassDescription();
        if (!doc.equals("")) {
            getJavaDoc().addLine(doc);
        }
    }

    public static String createListName(String name) {
        return getNameAdjuster().toValueName(name) + "List";
    }
}
