/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.expander.processor;

import java.util.Iterator;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.report.definition.FormSet;
import blanco.report.definition.FormSetSpecification;
import blanco.report.definition.FormSpecification;
import blanco.report.expander.TypeFactory;
import blanco.report.runtime.AbstractReportProcessor;

/**
 * @author Yasuo Nakanishi
 */
public class ReportProcessorClass extends ClassExpander {
    private TypeFactory _typeFactory = null;

    private FormSet _formSet = null;

    public ReportProcessorClass(Type type, TypeFactory typeFactory,
            FormSet formSet) {
        super(type);
        _typeFactory = typeFactory;
        _formSet = formSet;
    }

    protected void expandClassStruct() {
        Type type = _typeFactory.getRuntimeType(AbstractReportProcessor.class);
        setSuperClass(type);

        String path = _formSet.getFormPath();
        FormSetSpecification specification = _formSet.getSpecification();

        addMethod(new ReportProcessorConstructor(getType(), path,
                specification, _typeFactory));
        Iterator formIterator = _formSet.getFormSpecificationIterator();

        FormSpecification form = null;
        while (formIterator.hasNext()) {
            form = (FormSpecification) formIterator.next();
            expandForm(form);
        }

        String doc = "";
        if (!specification.getJpName().equals("")) {
            doc = specification.getJpName() + "|[gvZbTNXB";
        } else {
            doc = specification.getName() + " |[gvZbTNXB";
        }
        getJavaDoc().addLine(doc);

        doc = specification.getClassDescription();
        if (!doc.equals("")) {
            getJavaDoc().addLine(doc);
        }
    }

    protected void expandForm(FormSpecification specification) {
        addMethod(new NewPageMethod(specification));
        addMethod(new SetPageDataMethod(specification, _typeFactory));
    }
}
