/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.expander.processor;

import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.Constructor;
import blanco.report.definition.FormSetSpecification;
import blanco.report.definition.OutputType;
import blanco.report.expander.TypeFactory;

/**
 * @author Yasuo Nakanishi
 */
public class ReportProcessorConstructor extends Constructor {

    private String _path = "";

    private OutputType _outputType = null;

    private TypeFactory _typeFactory = null;

    public ReportProcessorConstructor(Type type, String path,
            FormSetSpecification specification, TypeFactory typeFactory) {
        super(type);

        _path = path;
        _outputType = specification.getOutputType();
        _typeFactory = typeFactory;
    }

    public void setupSignature() {
        super.setupSignature();
    }

    public void implement() {
        Implementor i = new Implementor(getData());

        Type runtimeOutputType = _typeFactory.getRuntimeType(OutputType.class);
        Call c = new Call("super");
        c.addArgument(new StringLiteral(_path));
        c.addArgument(new Receiver(runtimeOutputType, _outputType.getName()));
        i.addStatement(c);
    }

}
