/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.api.excel.CellParser;
import blanco.api.excel.CellPointer;
import blanco.api.excel.CellRangeParser;
import blanco.api.excel.CellType;
import blanco.api.excel.ExcelBook;
import blanco.api.excel.ExcelBookCreator;
import blanco.api.excel.ExcelSheet;
import blanco.api.excel.oo.CalcService;
import blanco.api.excel.oo.OoExcelBook;
import blanco.api.excel.oo.OoExcelBookCreator;
import blanco.api.excel.oo.OoExcelSheet;
import blanco.api.oo.launchar.OOoLauncher;
import blanco.api.oo.uno.UnoService;
import blanco.core.datastruct.DataStructClass;
import blanco.ig.expander.Type;
import blanco.ig.generator.Generator;
import blanco.ig.generator.ImplementGenerator;
import blanco.ig.generator.RuntimeGenerator;
import blanco.ig.service.ServiceClass;
import blanco.ig.tool.ConsolePrinter;
import blanco.report.collector.BlancoReportCollector;
import blanco.report.definition.BlockItem;
import blanco.report.definition.FormDataStruct;
import blanco.report.definition.FormSet;
import blanco.report.definition.FormSetSpecification;
import blanco.report.definition.FormSpecification;
import blanco.report.definition.OutputType;
import blanco.report.definition.ReportServiceDefinition;
import blanco.report.expander.TypeFactory;
import blanco.report.expander.form.datastruct.BlockClass;
import blanco.report.expander.form.datastruct.PageDataClass;
import blanco.report.expander.processor.ReportProcessorClass;
import blanco.report.runtime.AbstractReportProcessor;
import blanco.report.runtime.BindedValue;
import blanco.report.runtime.FormSheet;
import blanco.report.runtime.Loop;
import blanco.report.runtime.TargetSheet;

/**
 * @author Yasuo Nakanishi
 * @author Tosiki Iga svȃtB[hϐ
 */
public class BlancoReportGenerator implements Generator {

    private ServiceClass _service = new ServiceClass("blancoRerort");

    private BlancoReportSetting _setting = null;

    private List _reportPathList = new ArrayList();

    private List _specificationPathList = new ArrayList();

    private ReportServiceDefinition _definition = new ReportServiceDefinition();

    private ImplementGenerator _ig = null;

    private RuntimeGenerator _rg = null;

    private ConsolePrinter _printer = ConsolePrinter.get();

    private BlancoReportCollector _collector = null;

    public BlancoReportGenerator(BlancoReportSetting setting) {
        _setting = setting;
        _ig = new ImplementGenerator(_service, setting);
        _rg = new RuntimeGenerator(_setting);
    }

    public void addReport(String reportPath, String specificationPath) {
        _reportPathList.add(reportPath);
        _specificationPathList.add(specificationPath);
    }

    public void addReport(FormSet definition) {
        _definition.addFormSet(definition);
    }

    public void generate() throws IOException {
        FormSet formSet = null;
        FormSetSpecification specification = null;
        Type type = null;
        ReportServiceDefinition definiton = null;

        TypeFactory _factory = new TypeFactory(_setting.getRootNameSpace());

        _printer.printInfo("blancoReport:Jn܂B");

        String reportPath = "";
        String specificationPath = "";
        _collector = new BlancoReportCollector(_setting);
        for (int i = 0; i < _reportPathList.size(); i++) {
            reportPath = (String) _reportPathList.get(i);
            specificationPath = (String) _specificationPathList.get(i);
            _collector.addFormSet(reportPath, specificationPath);
        }
        definiton = _collector.collect();

        Iterator reports = definiton.getFormSetIterator();
        while (reports.hasNext()) {
            _definition.addFormSet((FormSet) reports.next());
        }

        Iterator iterator = _definition.getFormSetIterator();
        while (iterator.hasNext()) {
            formSet = (FormSet) iterator.next();
            specification = formSet.getSpecification();
            _ig.addMain(new ReportProcessorClass(specification.getClassType(),
                    _factory, formSet));
        }

        setupDataStruct();

        generateRuntime();
        generateDataStruct();
        generateMain();

        _printer.printInfo("blancoReport:I܂B");

    }

    public void addRuntimeSourceDirectory(String path) {
        _rg.addSourceDirectory(path);
    }

    public void generateRuntime() throws IOException {
        _rg.addRuntime(OOoLauncher.class);
        _rg.addRuntime(UnoService.class);
        _rg.addRuntime(CellPointer.class);
        _rg.addRuntime(CellType.class);
        _rg.addRuntime(ExcelBook.class);
        _rg.addRuntime(ExcelBookCreator.class);
        _rg.addRuntime(ExcelSheet.class);
        _rg.addRuntime(OutputType.class);
        _rg.addRuntime(CalcService.class);
        _rg.addRuntime(OoExcelBook.class);
        _rg.addRuntime(OoExcelBookCreator.class);
        _rg.addRuntime(OoExcelSheet.class);
        _rg.addRuntime(CellParser.class);
        _rg.addRuntime(CellRangeParser.class);
        _rg.addRuntime(AbstractReportProcessor.class);
        _rg.addRuntime(BindedValue.class);
        _rg.addRuntime(FormSheet.class);
        _rg.addRuntime(Loop.class);
        _rg.addRuntime(TargetSheet.class);

        String nameSpace = "";
        nameSpace = _setting.getRootNameSpace() + ".api";
        _rg.addPackagePair("blanco.api", nameSpace);
        nameSpace = _setting.getRootNameSpace() + ".runtime";
        _rg.addPackagePair("blanco.report.runtime", nameSpace);
        _rg.addPackagePair("blanco.report.definition", nameSpace);
        _rg.generate();
    }

    public void generateDataStruct() throws IOException {
        _ig.generateDataStruct();
    }

    private void setupDataStruct() {
        List formList = new ArrayList();
        List itemList = new ArrayList();
        Iterator formSets = _definition.getFormSetIterator();

        FormSet formSet = null;

        Iterator forms = null;

        FormSpecification formSpecification = null;
        FormDataStruct formDataStruct = null;

        Iterator formBlocks = null;
        BlockItem listItem = null;

        while (formSets.hasNext()) {
            formSet = (FormSet) formSets.next();

            forms = formSet.getFormSpecificationIterator();
            while (forms.hasNext()) {
                formSpecification = (FormSpecification) forms.next();
                formDataStruct = formSpecification.getDataStruct();
                formList.add(formSpecification.getDataStruct());

                formBlocks = formDataStruct.getBlocksIterator();
                while (formBlocks.hasNext()) {
                    listItem = (BlockItem) formBlocks.next();
                    itemList.add(listItem);
                }
            }
        }

        Type type = null;
        DataStructClass expander = null;

        Iterator formDataStructs = formList.iterator();
        while (formDataStructs.hasNext()) {
            formDataStruct = (FormDataStruct) formDataStructs.next();
            type = formDataStruct.getClassType();
            expander = new PageDataClass(type, formDataStruct);
            _ig.addDataStruct(expander);
        }

        FormDataStruct itemDataStruct = null;

        Iterator itemDataStructs = itemList.iterator();
        while (itemDataStructs.hasNext()) {
            listItem = (BlockItem) itemDataStructs.next();
            type = listItem.getClassType();
            expander = new BlockClass(type, listItem);
            _ig.addDataStruct(expander);
        }
    }

    public void generateMain() throws IOException {
        _ig.generateMain();
    }

    public void generateTest() throws IOException {
    }
}
