/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.runtime;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import blanco.api.excel.CellParser;
import blanco.api.excel.CellPointer;
import blanco.api.excel.CellRangeParser;
import blanco.api.excel.ExcelSheet;

/**
 * @author Yasuo Nakanishi
 */
public class FormSheet {

    private ExcelSheet _sheet = null;

    private Map _parameterMap = new Hashtable();

    private Map _lineParameterMap = new Hashtable();

    private Map _loopRangeMap = new Hashtable();

    public FormSheet(ExcelSheet sheet) {
        _sheet = sheet;
    }

    public Iterator getLoopNameIterator() {
        return _loopRangeMap.keySet().iterator();
    }

    public void collectLineParameters(String loopName, String range) {

        String cellValue = "";
        String name = "";
        CellPointer pointer = null;

        _loopRangeMap.put(loopName, range);

        CellRangeParser parser = new CellRangeParser(range);
        CellPointer start = parser.getStartPointer();
        CellPointer end = parser.getEndPointer();

        for (int row = 0; row <= parser.getRowCount(); row++) {
            for (int column = 0; column <= parser.getColumnCount(); column++) {
                cellValue = _sheet.getText(column + start.getColumn(), row
                        + start.getRow());
                if (isParameterCell(cellValue)) {
                    name = cellValue.substring(1, cellValue.length());
                    pointer = CellParser.toAddress(column + start.getColumn(),
                            row + start.getRow());
                    addLineParameter(loopName, name, pointer);
                }
            }
        }
    }

    public String getLoopRange(String loopName) {
        return (String) _loopRangeMap.get(loopName);
    }

    public void collectParameters(String endAddress) {
        String cellValue = "";
        String name = "";
        CellPointer pointer = null;

        CellPointer end = CellParser.parse(endAddress);

        for (int row = 0; row <= end.getRow(); row++) {
            for (int column = 0; column <= end.getColumn(); column++) {
                cellValue = _sheet.getText(column, row);
                if (isParameterCell(cellValue)) {
                    name = cellValue.substring(1, cellValue.length());
                    pointer = CellParser.toAddress(column, row);
                    addParameter(name, pointer);
                }
            }
        }
    }

    private void addLineParameter(String loopName, String name,
            CellPointer address) {
        List list = (List) getLineAddressList(loopName, name);
        list.add(address);
    }

    private void addParameter(String name, CellPointer address) {
        List list = (List) getAddressList(name);
        list.add(address);
    }

    private List getAddressList(String name) {
        if (!_parameterMap.containsKey(name)) {
            _parameterMap.put(name, new ArrayList());
        }
        return (List) _parameterMap.get(name);
    }

    private List getLineAddressList(String loopName, String parameterName) {
        String key = loopName + "," + parameterName;
        if (!_lineParameterMap.containsKey(key)) {
            _lineParameterMap.put(key, new ArrayList());
        }
        return (List) _lineParameterMap.get(key);
    }

    public Iterator getParameterIterator(String name) {
        assert _parameterMap.containsKey(name);
        return getAddressList(name).iterator();
    }

    public Iterator getLineParameterIterator(String loopName,
            String parameterName) {
        assert _parameterMap.containsKey(parameterName);
        return getLineAddressList(loopName, parameterName).iterator();
    }

    private boolean isParameterCell(String value) {
        return value.startsWith("#");
    }

    public void setValue(CellPointer pointer, String value) {
        _sheet.setText(pointer, value);
    }
}
