/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.runtime;

import blanco.api.excel.CellPointer;
import blanco.api.excel.CellRangeParser;

/**
 * @author Yasuo Nakanishi
 */
public class Loop {

    private String _name = "";

    private CellPointer _baseStartPointer = null;

    private String _baseRange = "";

    private int _rowCount = 0;

    private CellPointer _startPointer = null;

    public Loop(String name, String range) {
        _name = name;
        _baseRange = range;
        reset();
    }

    private void reset() {
        CellRangeParser parser = new CellRangeParser(_baseRange);
        _rowCount = parser.getRowCount();
        _baseStartPointer = parser.getStartPointer();
        _startPointer = _baseStartPointer;
    }

    public void shift(int rowCount) {
        _baseStartPointer.move(0, rowCount);
        CellRangeParser parser = new CellRangeParser(_baseRange);
        CellPointer start = parser.getStartPointer().move(0, rowCount);
        CellPointer end = parser.getEndPointer().move(0, rowCount);
        _baseRange = start.getAddress() + ":" + end.getAddress();
        _startPointer = _startPointer.move(0, rowCount);
    }

    public int getCurrentRow() {
        return _startPointer.getRow();
    }

    public String getName() {
        return _name;
    }

    public int getRowCount() {
        return _rowCount;
    }

    public CellPointer getStartPointer() {
        return _startPointer;
    }

    public void newLine() {
        _startPointer = _startPointer.move(0, _rowCount);
    }

    public String getBaseRange() {
        return _baseRange;
    }

    public CellPointer getBaseStartPointer() {
        return _baseStartPointer;
    }

    public CellPointer getTargetCell(CellPointer address) {
        String gapRange = getGapRange(address);
        CellRangeParser parser = new CellRangeParser(gapRange);
        return _startPointer.move(parser.getColumnCount() - 1, parser
                .getRowCount() - 1);
    }

    private String getGapRange(CellPointer address) {
        String start = _baseStartPointer.getAddress();
        String end = address.getAddress();
        return start + ":" + end;
    }
}
