/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import blanco.api.excel.CellPointer;
import blanco.api.excel.ExcelSheet;

/**
 * @author Yasuo Nakanishi
 */
public class TargetSheet {

    private List _loopList = null;

    private FormSheet _formSheet = null;

    private ExcelSheet _targetSheet = null;

    private int _blockCount = 0;

    public TargetSheet(FormSheet formSheet, ExcelSheet targetSheet) {
        _formSheet = formSheet;
        _targetSheet = targetSheet;
    }

    public void copyRange(String source, String destination) {
        _targetSheet.copyRange(source, destination);
    }

    private List getLoopList() {
        if (_loopList == null) {
            _loopList = new ArrayList();
            sortLoops();
        }
        return _loopList;
    }

    public void sortLoops() {
        Iterator i = _formSheet.getLoopNameIterator();
        String name = "";
        int index = 0;
        Loop loop = null;
        while (i.hasNext()) {
            name = (String) i.next();
            loop = new Loop(name, _formSheet.getLoopRange(name));
            index = findLoopIndex(loop);
            _loopList.add(index, loop);
        }
    }

    private int findLoopIndex(Loop loop) {
        int result = 0;
        Loop loopInList = null;
        for (int i = 0; i < getLoopList().size(); i++) {
            loopInList = (Loop) getLoopList().get(i);
            if (loopInList.getCurrentRow() > loop.getCurrentRow()) {
                result = i;
                break;
            }
        }
        return result;
    }

    private int getLoopIndex(String loopName) {
        int result = 0;
        Loop loopInList = null;
        List list = getLoopList();
        for (int i = 0; i < list.size(); i++) {
            loopInList = (Loop) list.get(i);
            if (loopInList.getName().equals(loopName)) {
                result = i;
                break;
            }
        }
        return result;
    }

    private Loop getLoop(String loopName) {
        return (Loop) getLoopList().get(getLoopIndex(loopName));
    }

    public void newLine(String loopName) {
        Loop loop = getLoop(loopName);

        loop.newLine();
        String range = loop.getBaseRange();
        CellPointer pointer = loop.getStartPointer();

        _targetSheet.copyRange(range, pointer.getAddress());
        shiftAfterLoop(loop);
        _blockCount++;
    }

    private void shiftAfterLoop(Loop loop) {
        int index = getLoopIndex(loop.getName());

        int rowCount = loop.getRowCount();
        Loop target = null;
        for (int i = index + 1; i < _loopList.size(); i++) {
            target = (Loop) _loopList.get(i);
            target.shift(rowCount);
        }
    }

    public void setBlockText(String loopName, CellPointer address, String text) {
        Loop loop = getLoop(loopName);
        String range = loop.getBaseRange();
        CellPointer targetCell = loop.getTargetCell(address);
        _targetSheet.setText(targetCell, text);
    }

    public void setBlockNumber(String loopName, CellPointer address,
            double number) {
        Loop loop = getLoop(loopName);
        String range = loop.getBaseRange();
        CellPointer targetCell = loop.getTargetCell(address);
        _targetSheet.setNumber(targetCell, number);
    }

    public void setBlockDate(String loopName, CellPointer address, Date date) {
        Loop loop = getLoop(loopName);
        String range = loop.getBaseRange();
        CellPointer targetCell = loop.getTargetCell(address);
        _targetSheet.setDate(targetCell, date);
    }

    public CellPointer getLoopStartAddress(String loopName) {
        return getLoop(loopName).getStartPointer();
    }

    public int getColumnCount() {
        return _targetSheet.getColumnCount();
    }

    public int getRowCount() {
        return _targetSheet.getRowCount();
    }

    public String getValue(int column, int row) {
        return _targetSheet.getText(column, row);
    }

    public void removeRange(String range) {
        _targetSheet.removeRange(range);
    }

    private void setValue(int column, int row, String value) {
        _targetSheet.setText(column, row, value);
    }

    public void setDate(CellPointer pointer, Date value) {
        _targetSheet.setDate(pointer.getColumn(), pointer.getRow(), value);
    }

    public void setText(CellPointer address, String value) {
        _targetSheet.setText(address, value);
    }

    public void clean() {
        removeLoopsRange();
    }

    private void removeLoopsRange() {
        String range = "";

        List list = getLoopList();
        Loop loop = null;
        for (int i = list.size() - 1; i >= 0; i--) {
            loop = (Loop) list.get(i);
            range = loop.getBaseRange();
            _targetSheet.removeRange(range);
        }
    }

    public void setValue(CellPointer pointer, double number) {
        _targetSheet.setNumber(pointer, number);
    }

    public int getBlockCount() {
        return _blockCount;
    }
}
