/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.oo.launchar;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

/**
 * @author Yasuo Nakanishi
 */
public class OOoLauncherTest extends TestCase {

    public void testSingleBoot() {
        String executeFile = "C:/Program Files/OpenOffice.org1.1.4/program/soffice.exe";
        int port = 8100;
        OOoLauncher target = new OOoLauncher(executeFile, port);

        target.start();
        target.stop();
    }

    public void testDoubleBoot() {
        String executeFile = "C:/Program Files/OpenOffice.org1.1.4/program/soffice.exe";
        int port = 8100;
        OOoLauncher target = new OOoLauncher(executeFile, port);
        BootThread thread = null;
        List list = new ArrayList();

        for (int i = 0; i < 10; i++) {
            list.add(new BootThread(Integer.toString(i)));
        }

        System.out.println("Start[main]");
        target.start();
        for (int i = 0; i < list.size(); i++) {
            thread = (BootThread) list.get(i);
            thread.start();
        }
        target.stop();
        System.out.println("Stop[main]");
        while (list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                thread = (BootThread) list.get(i);
                if (!thread.isAlive()) {
                    list.remove(thread);
                    break;
                }
            }
        }
    }

    public void testOtherPort() {
        String executeFile = "C:/Program Files/OpenOffice.org1.1.4/program/soffice.exe";
        int port = 8122;
        OOoLauncher target = new OOoLauncher(executeFile, port);

        target.start();
        target.stop();
    }

    class BootThread extends Thread {
        private String _name = "";

        public BootThread(String name) {
            _name = name;
        }

        public void run() {
            String executeFile = "C:/Program Files/OpenOffice.org1.1.4/program/soffice.exe";
            int port = 8100;
            OOoLauncher target = new OOoLauncher(executeFile, port);

            System.out.println("Start[" + _name + "]");
            target.start();
            System.out.println("Boot[" + _name + "]");
            target.stop();
            System.out.println("Stop[" + _name + "]");
        }
    }
}
