/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.oo.uno;

import junit.framework.TestCase;
import blanco.api.oo.launchar.OOoLauncher;

/**
 * @author Yasuo Nakanishi
 */
public class UnoServiceTest extends TestCase {

    public void test() throws Exception {
        String host = "localhost";
        int port = 8100;
        String executeFile = "C:/Program Files/OpenOffice.org1.1.4/program/soffice.exe";

        OOoLauncher _launcher = new OOoLauncher(executeFile, port);
        try {
            _launcher.start();
            UnoService target = new UnoService(host, port);
            target.connect();
            target.close();
        } finally {
            _launcher.stop();
        }

    }
}
