/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.excel.api.oo;

import java.io.FileNotFoundException;

import blanco.api.excel.ExcelBook;
import blanco.api.excel.ExcelBookCreator;
import blanco.api.excel.oo.CalcService;
import blanco.api.excel.oo.OoExcelBookCreator;
import blanco.api.oo.launchar.OOoLauncher;
import blanco.report.BlancoReportTestCase;

/**
 * @author Yasuo Nakanishi
 */
public class OoExcelBookCreatorTest extends BlancoReportTestCase {
    private OOoLauncher _launcher = new OOoLauncher(
            "C:\\Program Files\\OpenOffice.org1.1.4\\program\\soffice.exe",
            8100);

    private CalcService _service = new CalcService("localhost", 8100);

    protected void setUp() throws Exception {
        super.setUp();

        _launcher.start();
        _service.connect();
    }

    protected void tearDown() throws Exception {
        super.tearDown();

        _service.close();
        _launcher.stop();
    }

    public void testCreateNeFile() throws Exception {

        ExcelBookCreator target = new OoExcelBookCreator(_service);

        ExcelBook book = target.createNewFile();
        book.close();
    }

    public void testOpenBook() throws Exception {
        ExcelBookCreator target = new OoExcelBookCreator(_service);

        String path = getLocalPath("./report/form/SimpleFormSet.xls");
        ExcelBook book = target.openBook(path);
        book.close();

        path = getLocalPath(".");
        try {
            target.openBook(path);
        } catch (FileNotFoundException e) {
            assertTrue(true);
        }
    }
}
