/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.generator;

import java.io.IOException;

import blanco.report.BlancoReportTestCase;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoReportGeneratorTest extends BlancoReportTestCase {

    public void testGenerate() throws IOException {
        BlancoReportSetting setting = BlancoReportSettingTest.create();
        setting.setRootNameSpace("test.blanco.report");
        setting
                .setOpenOfficeExecuteFile("C:\\Program Files\\OpenOffice.org1.1.4\\program\\soffice.exe");

        BlancoReportGenerator target = new BlancoReportGenerator(setting);

        target.addRuntimeSourceDirectory(getLocalPath("src/main"));
        // target.addReport(ReportDefinitionTest.createSimple());

        String formPath = "";
        String specificationPath = "";

        formPath = getLocalPath("SimpleFormSet.xls");
        specificationPath = getLocalPath("SimpleFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("OutputPdfFormSet.xls");
        specificationPath = getLocalPath("OutputPdfFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("OutputXlsFormSet.xls");
        specificationPath = getLocalPath("OutputXlsFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NameComplementFormSet.xls");
        specificationPath = getLocalPath("NameComplementFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("UserNameFormSet.xls");
        specificationPath = getLocalPath("UserNameFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("CalculateFormSet.xls");
        specificationPath = getLocalPath("CalculateFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("AllCellTypeFormSet.xls");
        specificationPath = getLocalPath("AllCellTypeFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("EmbedGraphicFormSet.xls");
        specificationPath = getLocalPath("EmbedGraphicFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("LinkedGraphicFormSet.xls");
        specificationPath = getLocalPath("LinkedGraphicFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("ShapeFormSet.xls");
        specificationPath = getLocalPath("ShapeFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("DoubleBlockFormSet.xls");
        specificationPath = getLocalPath("DoubleBlockFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("MultiLineBlockFormSet.xls");
        specificationPath = getLocalPath("MultiLineBlockFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("SameNameFormSet.xls");
        specificationPath = getLocalPath("SameNameFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        target.generate();
    }

    public void testOtherPort() throws IOException {
        BlancoReportSetting setting = BlancoReportSettingTest.create();
        setting.setRootNameSpace("test.blanco.report");
        setting
                .setOpenOfficeExecuteFile("C:\\Program Files\\OpenOffice.org1.1.4\\program\\soffice.exe");
        setting.setUnoPort(8122);

        BlancoReportGenerator target = new BlancoReportGenerator(setting);

        target.addRuntimeSourceDirectory(getLocalPath("src/main"));

        String formPath = "";
        String specificationPath = "";

        formPath = getLocalPath("SimpleFormSet.xls");
        specificationPath = getLocalPath("SimpleFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        target.generate();
    }

    public void testError() throws IOException {
        BlancoReportSetting setting = BlancoReportSettingTest.create();
        setting.setRootNameSpace("test.blanco.report");
        setting
                .setOpenOfficeExecuteFile("C:\\Program Files\\OpenOffice.org1.1.4\\program\\soffice.exe");

        BlancoReportGenerator target = new BlancoReportGenerator(setting);

        target.addRuntimeSourceDirectory(getLocalPath("src/main"));

        String formPath = "";
        String specificationPath = "";

        formPath = getLocalPath("HogeFormSet.xls");
        specificationPath = getLocalPath("HogeFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("SimpleFormSet.xls");
        specificationPath = getLocalPath("HogeFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoOutputTypeFormSet.xls");
        specificationPath = getLocalPath("NoOutputTypeFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoReportNameFormSet.xls");
        specificationPath = getLocalPath("NoReportNameFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoFormSetSpecificationSheetFormSet.xls");
        specificationPath = getLocalPath("NoFormSetSpecificationSheetFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoEndCellFormSet.xls");
        specificationPath = getLocalPath("NoEndCellFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoFieldCellTypeFormSet.xls");
        specificationPath = getLocalPath("NoFieldCellTypeFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NameDuplicationFormSet.xls");
        specificationPath = getLocalPath("NameDuplicationFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoBlockDefinitionFormSet.xls");
        specificationPath = getLocalPath("NoBlockDefinitionFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoFieldBlockFormSet.xls");
        specificationPath = getLocalPath("NoFieldBlockFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoBlockRangeFormSet.xls");
        specificationPath = getLocalPath("NoBlockRangeFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        formPath = getLocalPath("NoFormNameFormSet.xls");
        specificationPath = getLocalPath("NoFormNameFormSetDef.xls");
        target.addReport(formPath, specificationPath);

        target.generate();
    }
}
