/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel;

import junit.framework.TestCase;
import blanco.api.excel.CellParser;
import blanco.api.excel.CellPointer;

/**
 * @author Yasuo Nakanishi
 */
public class CellPointerTest extends TestCase {

    public void testConstruct() {
        CellPointer target = null;

        target = new CellPointer("B2");
        assertEquals(1, target.getColumn());
        assertEquals(1, target.getRow());

        target = new CellPointer("B21");
        assertEquals(1, target.getColumn());
        assertEquals(20, target.getRow());
    }

    public void testParse() {
        String cellRange = "";
        CellPointer result = null;

        cellRange = "A1";
        result = CellParser.parse(cellRange);

        assertEquals(0, result.getColumn());
        assertEquals(0, result.getRow());

        cellRange = "B32";
        result = CellParser.parse(cellRange);

        assertEquals(1, result.getColumn());
        assertEquals(31, result.getRow());

        cellRange = "AA32";
        result = CellParser.parse(cellRange);

        assertEquals(26, result.getColumn());
        assertEquals(31, result.getRow());
    }

    public void testToAddress() {
        String address = "";

        address = CellParser.toAddress(0, (short) 0).getAddress();
        assertEquals(address, "A1");

        address = CellParser.toAddress(25, (short) 32).getAddress();
        assertEquals(address, "Z33");

        address = CellParser.toAddress(26, (short) 54).getAddress();
        assertEquals(address, "AA55");

        address = CellParser.toAddress(52, (short) 99).getAddress();
        assertEquals(address, "BA100");

        address = CellParser.toAddress(255, (short) 0).getAddress();
        assertEquals(address, "IV1");
    }
}
