/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel;

import blanco.api.excel.CellRangeParser;
import junit.framework.TestCase;

/**
 * @author Yasuo Nakanishi
 */
public class CellRangeParserTest extends TestCase {

    public void testRange() {
        CellRangeParser target = null;
        String cellRange = "";

        cellRange = "A1:A2";
        target = new CellRangeParser(cellRange);

        assertEquals(0, target.getStartPointer().getColumn());
        assertEquals(0, target.getStartPointer().getRow());
        assertEquals(0, target.getEndPointer().getColumn());
        assertEquals(1, target.getEndPointer().getRow());

        cellRange = "AZ18:B32";
        target = new CellRangeParser(cellRange);

        assertEquals(51, target.getStartPointer().getColumn());
        assertEquals(17, target.getStartPointer().getRow());
        assertEquals(1, target.getEndPointer().getColumn());
        assertEquals(31, target.getEndPointer().getRow());

        cellRange = "AA32:BB65";
        target = new CellRangeParser(cellRange);

        assertEquals(26, target.getStartPointer().getColumn());
        assertEquals(31, target.getStartPointer().getRow());
        assertEquals(53, target.getEndPointer().getColumn());
        assertEquals(64, target.getEndPointer().getRow());
    }

    public void testGetRowCount() {
        CellRangeParser target = null;
        String cellRange = "";

        cellRange = "A1:A2";
        target = new CellRangeParser(cellRange);

        assertEquals(2, target.getRowCount());
    }
}
