/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel;

/**
 * @author Yasuo Nakanishi
 */
public class CellPointer {

    private int _column = 0;

    private int _row = 0;

    private String _address = "";

    public CellPointer(int column, int row, String address) {
        _column = column;
        _row = row;
        _address = address;
    }

    public CellPointer(int column, int row) {
        _column = column;
        _row = row;
        _address = CellParser.toString(column, row);
    }

    public CellPointer(String address) {
        _address = address;
        _column = CellParser.parseColumnNumber(address);
        _row = CellParser.parseRowNumber(address);
    }

    public String getAddress() {
        return _address;
    }

    public int getColumn() {
        return _column;
    }

    public int getRow() {
        return _row;
    }

    public CellPointer move(int column, int row) {
        CellPointer result = new CellPointer(_column + column, _row + row);
        return result;
    }
}
