/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel;

import java.io.IOException;

/**
 * @author Yasuo Nakanishi
 */
public interface ExcelBook {

    public ExcelSheet createSheet(String name);

    public boolean hasSheet(String name);

    public ExcelSheet getSheet(String name);

    public ExcelSheet getSheet(short position);

    public int getSheetCount();

    public void removeSheet(String name);

    public void copySheet(String souce, String distination, short position);

    public void copySheet(String souce, String distination);

    public void saveAs(String path) throws IOException;

    public void save() throws IOException;

    public void close();

    public String getFilePath();
}
