/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel;

import java.util.Date;

/**
 * @author Yasuo Nakanishi
 */
public interface ExcelSheet {

    public String getName();

    public ExcelBook getBook();

    public String getText(int column, int row);

    public String getText(CellPointer pointer);

    public double getNumber(int column, int row);

    public double getNumber(CellPointer pointer);

    public void setText(int column, int row, String value);

    public void setText(CellPointer CellPointer, String value);

    public void setNumber(int column, int row, double value);

    public void setNumber(CellPointer pointer, double value);

    public void setDate(int column, int row, Date value);

    public void setDate(CellPointer pointer, Date value);

    public void copyRange(String source, String destination);

    public void removeRange(String range);

    public CellType getCellType(int column, int row);

    public CellType getCellType(CellPointer pointer);

    public int getRowCount();

    public int getColumnCount();
}
