/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel.oo;

import blanco.api.oo.uno.UnoService;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XCellAddressable;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XCellRangeFormula;
import com.sun.star.sheet.XCellRangeMovement;
import com.sun.star.sheet.XSheetCellRange;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XText;

/**
 * @author Yasuo Nakanishi
 */
public class CalcService extends UnoService {

    public CalcService(String host, int port) {
        super(host, port);
    }

    public CalcService(String host, int port, boolean hide) {
        super(host, port, hide);
    }

    public XComponent newSpreadsheetComponent() throws IOException,
            IllegalArgumentException, Exception {
        XComponent result = null;
        PropertyValue[] properties = new PropertyValue[1];
        properties[0] = new PropertyValue();
        properties[0].Name = "Hide";
        properties[0].Value = new Boolean(isHide());

        result = getComponentLoader().loadComponentFromURL(
                "private:factory/scalc", "_blank", 0, properties);
        assert result != null;
        return result;
    }

    public XStorable getStorable(XComponent component) {
        return (XStorable) getInterface(XStorable.class, component);
    }

    public XSpreadsheetDocument getSpreadsheetDocument(
            XComponent spreadsheetComponent) {
        Class type = XSpreadsheetDocument.class;
        return (XSpreadsheetDocument) getInterface(type, spreadsheetComponent);
    }

    public CellRangeAddress getCellRangeAddress(XSpreadsheet sheet,
            String cellRange) {
        XCellRange range = sheet.getCellRangeByName(cellRange);
        XCellRangeAddressable address = (XCellRangeAddressable) getInterface(
                XCellRangeAddressable.class, range);
        return address.getRangeAddress();
    }

    public XCellRangeMovement getCellRangeMovement(XSpreadsheet sheet) {
        return (XCellRangeMovement) getInterface(XCellRangeMovement.class,
                sheet);
    }

    public CellAddress getCellAddress(XSpreadsheet sheet, String cell) {
        XCell c = null;
        try {
            c = sheet.getCellRangeByName(cell).getCellByPosition(0, 0);
        } catch (IndexOutOfBoundsException e) {
            String message = "sȃZւ̃ANZXBZ:" + cell;
            throw new RuntimeException(message);
        }
        XCellAddressable address = (XCellAddressable) getInterface(
                XCellAddressable.class, c);
        return address.getCellAddress();
    }

    public XText getText(XCell cell) {
        return (XText) getInterface(XText.class, cell);
    }

    public XPropertySet getCellPropertySet(XCell cell) {
        return (XPropertySet) getInterface(XPropertySet.class, cell);
    }

    public XPropertySet getCellPropertySet(XCellRange cellRange) {
        return (XPropertySet) getInterface(XPropertySet.class, cellRange);
    }

    public XPropertySet getCellPropertySet(Object cellRange) {
        return (XPropertySet) getInterface(XPropertySet.class, cellRange);
    }

    public XSheetCellRange getSheetCellRange(XSpreadsheet sheet) {
        return (XSheetCellRange) getInterface(XSheetCellRange.class, sheet);
    }

    public XColumnRowRange getColumnRowRange(XSheetCellRange cellRange) {
        return (XColumnRowRange) getInterface(XColumnRowRange.class, cellRange);
    }

    public XColumnRowRange getColumnRowRange(XSpreadsheet sheet) {
        XSheetCellRange cellRange = getSheetCellRange(sheet);
        return (XColumnRowRange) getInterface(XColumnRowRange.class, cellRange);
    }

    public XEnumeration getEnumerationAccess(XTableRows rows) {
        XEnumerationAccess access = (XEnumerationAccess) getInterface(
                XEnumerationAccess.class, rows);
        return access.createEnumeration();
    }

    public XModel getModel(XSpreadsheetDocument document) {
        return (XModel) getInterface(XModel.class, document);
    }

    public XNamed getNamed(XSpreadsheet sheet) {
        return (XNamed) getInterface(XNamed.class, sheet);
    }

    public XIndexAccess getIndexAccess(XSpreadsheets sheets) {
        return (XIndexAccess) getInterface(XIndexAccess.class, sheets);
    }

    public XCellRangeFormula getCellRangeFormula(XCellRange range) {
        return (XCellRangeFormula) getInterface(XCellRangeFormula.class, range);
    }
}
