/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.api.excel.oo;

import java.io.File;
import java.io.FileNotFoundException;

import blanco.api.excel.ExcelBook;
import blanco.api.excel.ExcelBookCreator;

import com.sun.star.lang.XComponent;

/**
 * @author Yasuo Nakanishi
 */
public class OoExcelBookCreator implements ExcelBookCreator {

    private CalcService _service = null;

    private boolean _hide = false;

    public OoExcelBookCreator(CalcService service) {
        _service = service;
    }

    public ExcelBook createNewFile() throws Exception {
        ExcelBook result = null;
        XComponent component = _service.newSpreadsheetComponent();
        result = new OoExcelBook(_service, component);
        return result;
    }

    public ExcelBook openBook(String path) throws Exception {
        OoExcelBook result = null;

        File f = new File(path);

        if (!f.exists()) {
            String message = "t@C܂łBt@C:" + path;
            throw new FileNotFoundException(message);
        }
        String loadUrl = f.toURL().toString();

        XComponent component = _service.loadComponent(loadUrl);
        result = new OoExcelBook(_service, component);
        return result;
    }
}
