/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.collector;

import blanco.api.excel.ExcelBook;
import blanco.api.excel.ExcelSheet;
import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;
import blanco.report.definition.FormSetSpecification;
import blanco.report.definition.OutputType;

/**
 * @author Yasuo Nakanishi
 */
public class FormSetSpecificationCollector {
    private ExcelBook _book = null;

    private ExcelSheet _sheet = null;

    private String _rootNameSpace = "";

    private FormSetSpecificationParser _parser = null;

    public FormSetSpecificationCollector(ExcelBook book, ExcelSheet sheet,
            String rootNameSpace) {
        _book = book;
        _sheet = sheet;
        _rootNameSpace = rootNameSpace;
        _parser = new FormSetSpecificationParser(_sheet);
    }

    public void parse() throws Exception {
        _parser.parse();
    }

    public void validate() {
        FormSetSpecificationValidator validator = new FormSetSpecificationValidator(
                _book, _parser);
        validator.validate();
    }

    public FormSetSpecification collect() {
        String name = _parser.getReportName();
        FormSetSpecification result = new FormSetSpecification(name);
        result.setJpName(_parser.getJpName());
        result.setClassDescription(_parser.getClassDescription());
        result.setClassType(getType(name));
        result.setOutputType(OutputType.parse(_parser.getOutputType()));
        return result;
    }

    private Type getType(String name) {
        String packageName = _parser.getClassPackage();
        if (packageName.equals("")) {
            packageName = _rootNameSpace;
        }
        String className = _parser.getClassName();
        if (className.equals("")) {
            NameAdjuster adjuster = new NameAdjuster();
            className = adjuster.toClassName(_parser.getReportName())
                    + "ReportProcessor";
        }
        return new Type(packageName, className);
    }
}
