/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.collector;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import blanco.api.excel.ExcelBook;

/**
 * @author Yasuo Nakanishi
 */
public class FormSpecificationValidator {
    private ExcelBook _formSetBook = null;

    private ExcelBook _specificationBook = null;

    private FormSpecificationParser _parser = null;

    public FormSpecificationValidator(ExcelBook formSetBook,
            ExcelBook specificationBook, FormSpecificationParser parser) {
        _formSetBook = formSetBook;
        _specificationBook = specificationBook;
        _parser = parser;
    }

    public void validate() {
        String value = "";

        value = _parser.getFormName();
        if (value.equals("")) {
            String message = "tH[w肳Ă܂BubN:";
            message += _specificationBook.getFilePath();
            message += ", V[g:";
            message += _parser.getSheet().getName();
            throw new RuntimeException(message);
        }

        value = _parser.getFormName();
        if (!_formSetBook.hasSheet(value)) {
            String message = "tH[Zbgt@CɃtH[Ŏw肳ꂽV[g܂BtH[ZbgubN:";
            message += _formSetBook.getFilePath();
            message += ", tH[Zbg`:";
            message += _specificationBook.getFilePath();
            message += ", V[g:";
            message += value;
            throw new RuntimeException(message);
        }

        value = _parser.getEndCellAddress();
        if (value.equals("")) {
            String message = "IZw肳Ă܂BubN:";
            message += _specificationBook.getFilePath();
            message += ", V[g:";
            message += _parser.getSheet().getName();
            throw new RuntimeException(message);
        }

        int index = 0;
        String name = "";
        String block = "";
        String nameKey = "";
        Map _nameKeyMap = new Hashtable();

        while (true) {
            name = _parser.getFieldName(index);
            if (name.equals("")) {
                break;
            }

            try {
                _parser.getFieldCellType(index);
            } catch (RuntimeException e) {
                String message = "sȃZ̎ނw肳܂BubN:";
                message += _specificationBook.getFilePath();
                message += ",V[g:";
                message += _parser.getSheet().getName();
                message += ",tB[h:";
                message += name;
                message += ",Z̎:";
                message += name;
                throw new RuntimeException(message, e);
            }

            block = _parser.getFieldBlock(index);
            nameKey = name + "," + block;
            if (_nameKeyMap.containsKey(nameKey)) {
                String message = "OdĂ܂BubN:";
                message += _specificationBook.getFilePath();
                message += ",V[g:";
                message += _parser.getSheet().getName();
                message += ",tB[h:";
                message += name;
                if (!block.equals("")) {
                    message += ",ubN:";
                    message += block;
                }
                throw new RuntimeException(message);
            } else {
                _nameKeyMap.put(nameKey, nameKey);
            }
            index++;
        }

        validateBlock();
    }

    public void validateBlock() {

        int index = 0;
        String block = "";
        String range = "";

        while (true) {
            block = _parser.getBlockName(index);
            range = _parser.getBlockRange(index);

            if (block.equals("")) {
                break;
            }

            if (!block.equals("") && range.equals("")) {
                String message = "ubN͈̔͂w肳Ă܂BubN:";
                message += _specificationBook.getFilePath();
                message += ",V[g:";
                message += _parser.getSheet().getName();
                message += ",ubN:";
                message += block;
                throw new RuntimeException(message);
            }
            index++;
        }

        Map blockDefinitons = new Hashtable();
        index = 0;
        while (true) {
            block = _parser.getBlockName(index);
            if (!block.equals("")) {
                blockDefinitons.put(block, block);
            } else {
                break;
            }
            index++;
        }

        Map fieldBlocks = new Hashtable();
        String name = "";
        index = 0;
        while (true) {
            name = _parser.getFieldName(index);

            if (name.equals("")) {
                break;
            }

            block = _parser.getFieldBlock(index);
            if (!block.equals("") && !fieldBlocks.containsKey(block)) {
                fieldBlocks.put(block, block);
            }
            index++;
        }

        Iterator blocks = null;

        blocks = fieldBlocks.keySet().iterator();
        while (blocks.hasNext()) {
            block = (String) blocks.next();
            if (!blockDefinitons.containsKey(block)) {
                String message = "tB[hŎgpĂubN̒`܂BubN:";
                message += _specificationBook.getFilePath();
                message += ",V[g:";
                message += _parser.getSheet().getName();
                message += ",ubN:";
                message += block;
                throw new RuntimeException(message);
            }
        }

        blocks = blockDefinitons.keySet().iterator();
        while (blocks.hasNext()) {
            block = (String) blocks.next();
            if (!fieldBlocks.containsKey(block)) {
                String message = "`ĂubNtB[h̒`ŎgpĂ܂BubN:";
                message += _specificationBook.getFilePath();
                message += ",V[g:";
                message += _parser.getSheet().getName();
                message += ",ubN:";
                message += block;
                throw new RuntimeException(message);
            }
        }
    }
}
