/*
 * blancoReport
 * Copyright (C) 2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.report.definition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class FormSet {
    private String _formPath = "";

    private FormSetSpecification _specification = null;

    private List _forms = new ArrayList();

    public FormSet(String reportPath, FormSetSpecification specification) {
        _formPath = reportPath;
        _specification = specification;
    }

    public String getName() {
        return _specification.getName();
    }

    public void addForm(FormSpecification form) {
        _forms.add(form);
    }

    public Iterator getFormSpecificationIterator() {
        return _forms.iterator();
    }

    public FormSetSpecification getSpecification() {
        return _specification;
    }

    public String getFormPath() {
        return _formPath;
    }
}
